/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhases;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class NodeOperation
implements Writeable {
    private static final Logger LOGGER = LogManager.getLogger(NodeOperation.class);
    public static final int NO_DOWNSTREAM = Integer.MAX_VALUE;
    private ExecutionPhase executionPhase;
    private Collection<String> downstreamNodes;
    private int downstreamExecutionPhaseId;
    private byte downstreamExecutionPhaseInputId;

    public NodeOperation(ExecutionPhase executionPhase, Collection<String> downstreamNodes, int downstreamExecutionPhaseId, byte downstreamExecutionPhaseInputId) {
        this.executionPhase = executionPhase;
        this.downstreamNodes = downstreamNodes;
        this.downstreamExecutionPhaseId = downstreamExecutionPhaseId;
        this.downstreamExecutionPhaseInputId = downstreamExecutionPhaseInputId;
    }

    public NodeOperation(StreamInput in) throws IOException {
        this.executionPhase = ExecutionPhases.fromStream(in);
        this.downstreamExecutionPhaseId = in.readVInt();
        this.downstreamExecutionPhaseInputId = in.readByte();
        int numExecutionNodes = in.readVInt();
        ArrayList<String> executionNodes = new ArrayList<String>();
        for (int i = 0; i < numExecutionNodes; ++i) {
            executionNodes.add(in.readString());
        }
        this.downstreamNodes = executionNodes;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        ExecutionPhases.toStream(out, this.executionPhase);
        out.writeVInt(this.downstreamExecutionPhaseId);
        out.writeByte(this.downstreamExecutionPhaseInputId);
        out.writeVInt(this.downstreamNodes.size());
        for (String executionNode : this.downstreamNodes) {
            out.writeString(executionNode);
        }
    }

    public static NodeOperation withoutDownstream(ExecutionPhase executionPhase) {
        return new NodeOperation(executionPhase, List.of(), Integer.MAX_VALUE, 0);
    }

    public static NodeOperation withDirectResponse(ExecutionPhase upstreamPhase, ExecutionPhase downstreamPhase, byte inputId, String localNodeId) {
        List<String> downstreamNodes;
        Collection<String> upstreamNodeIds = upstreamPhase.nodeIds();
        if (upstreamNodeIds.size() == 1 && downstreamPhase.nodeIds().size() == 1 && downstreamPhase.nodeIds().contains(localNodeId) && upstreamNodeIds.contains(localNodeId)) {
            LOGGER.trace("Phase uses SAME_NODE downstream, reason: ON HANDLER, executionNodes: {}, phase: {}", upstreamPhase.nodeIds(), (Object)upstreamPhase);
            downstreamNodes = Collections.emptyList();
        } else {
            downstreamNodes = ExecutionPhase.DIRECT_RESPONSE_LIST;
        }
        return new NodeOperation(upstreamPhase, downstreamNodes, downstreamPhase.phaseId(), inputId);
    }

    public static NodeOperation withDownstream(ExecutionPhase upstreamPhase, ExecutionPhase downstreamPhase, byte inputId) {
        return new NodeOperation(upstreamPhase, downstreamPhase.nodeIds(), downstreamPhase.phaseId(), inputId);
    }

    public ExecutionPhase executionPhase() {
        return this.executionPhase;
    }

    public Collection<String> downstreamNodes() {
        return this.downstreamNodes;
    }

    public int downstreamExecutionPhaseId() {
        return this.downstreamExecutionPhaseId;
    }

    public String toString() {
        return "NodeOp{ " + ExecutionPhases.debugPrint(this.executionPhase) + ", downstreamNodes=" + this.downstreamNodes + ", downstreamPhase=" + this.downstreamExecutionPhaseId + ", downstreamInputId=" + this.downstreamExecutionPhaseInputId + "}";
    }

    public byte downstreamExecutionPhaseInputId() {
        return this.downstreamExecutionPhaseInputId;
    }
}

