/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.AbstractProjectionsPhase;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.UpstreamPhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.PositionalOrderBy;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class MergePhase
extends AbstractProjectionsPhase
implements UpstreamPhase {
    private final Collection<? extends DataType<?>> inputTypes;
    private final int numUpstreams;
    private final int numInputs;
    private final Collection<String> executionNodes;
    private DistributionInfo distributionInfo;
    @Nullable
    private PositionalOrderBy positionalOrderBy;

    public MergePhase(UUID jobId, int executionNodeId, String name, int numUpstreams, int numInputs, Collection<String> executionNodes, Collection<? extends DataType<?>> inputTypes, List<Projection> projections, DistributionInfo distributionInfo, @Nullable PositionalOrderBy positionalOrderBy) {
        super(jobId, executionNodeId, name, projections);
        this.numInputs = numInputs;
        this.inputTypes = inputTypes;
        this.numUpstreams = numUpstreams;
        this.distributionInfo = distributionInfo;
        this.outputTypes = projections.isEmpty() ? List.copyOf(inputTypes) : Symbols.typeView(projections.get(projections.size() - 1).outputs());
        this.positionalOrderBy = positionalOrderBy;
        this.executionNodes = executionNodes;
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.MERGE;
    }

    @Override
    public Collection<String> nodeIds() {
        return this.executionNodes;
    }

    @Override
    public DistributionInfo distributionInfo() {
        return this.distributionInfo;
    }

    @Override
    public void distributionInfo(DistributionInfo distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    public int numUpstreams() {
        return this.numUpstreams;
    }

    public int numInputs() {
        return this.numInputs;
    }

    public Collection<? extends DataType<?>> inputTypes() {
        return this.inputTypes;
    }

    @Nullable
    public PositionalOrderBy orderByPositions() {
        return this.positionalOrderBy;
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitMergePhase(this, context);
    }

    public MergePhase(StreamInput in) throws IOException {
        super(in);
        int i;
        this.distributionInfo = new DistributionInfo(in);
        this.numUpstreams = in.readVInt();
        this.numInputs = in.readVInt();
        int numCols = in.readVInt();
        if (numCols > 0) {
            ArrayList inputTypes = new ArrayList(numCols);
            for (i = 0; i < numCols; ++i) {
                inputTypes.add(DataTypes.fromStream(in));
            }
            this.inputTypes = inputTypes;
        } else {
            this.inputTypes = Collections.emptyList();
        }
        int numExecutionNodes = in.readVInt();
        if (numExecutionNodes > 0) {
            this.executionNodes = new HashSet<String>(numExecutionNodes);
            for (i = 0; i < numExecutionNodes; ++i) {
                this.executionNodes.add(in.readString());
            }
        } else {
            this.executionNodes = Collections.emptySet();
        }
        this.positionalOrderBy = PositionalOrderBy.fromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.distributionInfo.writeTo(out);
        out.writeVInt(this.numUpstreams);
        out.writeVInt(this.numInputs);
        int numCols = this.inputTypes.size();
        out.writeVInt(numCols);
        for (DataType<?> inputType : this.inputTypes) {
            DataTypes.toStream(inputType, out);
        }
        out.writeVInt(this.executionNodes.size());
        for (String node : this.executionNodes) {
            out.writeString(node);
        }
        PositionalOrderBy.toStream(this.positionalOrderBy, out);
    }

    @Override
    public String toString() {
        return "MergePhase{executionPhaseId=" + this.phaseId() + ", name=" + this.name() + ", projections=" + this.projections + ", outputTypes=" + this.outputTypes + ", jobId=" + this.jobId() + ", numUpstreams=" + this.numUpstreams + ", numInputs=" + this.numInputs + ", nodeOperations=" + this.executionNodes + ", inputTypes=" + this.inputTypes + ", orderBy=" + this.positionalOrderBy + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MergePhase that = (MergePhase)o;
        return this.numUpstreams == that.numUpstreams && this.numInputs == that.numInputs && Objects.equals(this.inputTypes, that.inputTypes) && Objects.equals(this.executionNodes, that.executionNodes) && Objects.equals(this.distributionInfo, that.distributionInfo) && Objects.equals(this.positionalOrderBy, that.positionalOrderBy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inputTypes, this.numUpstreams, this.numInputs, this.executionNodes, this.distributionInfo, this.positionalOrderBy);
    }
}

