/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.JoinPhase;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.node.dql.join.JoinType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class HashJoinPhase
extends JoinPhase {
    private final List<Symbol> leftJoinConditionInputs;
    private final List<Symbol> rightJoinConditionInputs;
    private final Collection<DataType<?>> leftOutputTypes;
    private final long estimatedRowSizeForLeft;
    private final long numberOfRowsForLeft;

    public HashJoinPhase(UUID jobId, int executionNodeId, String name, List<Projection> projections, @Nullable MergePhase leftMergePhase, @Nullable MergePhase rightMergePhase, int numLeftOutputs, int numRightOutputs, Collection<String> executionNodes, @Nullable Symbol joinCondition, List<Symbol> leftJoinConditionInputs, List<Symbol> rightJoinConditionInputs, Collection<DataType<?>> leftOutputTypes, long estimatedRowSizeForLeft, long numberOfRowsForLeft) {
        super(jobId, executionNodeId, name, projections, leftMergePhase, rightMergePhase, numLeftOutputs, numRightOutputs, executionNodes, JoinType.INNER, joinCondition);
        assert (joinCondition != null) : "JoinCondition for HashJoin cannot be null";
        this.leftJoinConditionInputs = leftJoinConditionInputs;
        this.rightJoinConditionInputs = rightJoinConditionInputs;
        this.leftOutputTypes = leftOutputTypes;
        this.estimatedRowSizeForLeft = estimatedRowSizeForLeft;
        this.numberOfRowsForLeft = numberOfRowsForLeft;
    }

    public HashJoinPhase(StreamInput in) throws IOException {
        super(in);
        this.leftJoinConditionInputs = Symbols.listFromStream(in);
        this.rightJoinConditionInputs = Symbols.listFromStream(in);
        this.leftOutputTypes = DataTypes.listFromStream(in);
        this.estimatedRowSizeForLeft = in.readZLong();
        this.numberOfRowsForLeft = in.readZLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Symbols.toStream(this.leftJoinConditionInputs, out);
        Symbols.toStream(this.rightJoinConditionInputs, out);
        DataTypes.toStream(this.leftOutputTypes, out);
        out.writeZLong(this.estimatedRowSizeForLeft);
        out.writeZLong(this.numberOfRowsForLeft);
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.HASH_JOIN;
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitHashJoinPhase(this, context);
    }

    public List<Symbol> leftJoinConditionInputs() {
        return this.leftJoinConditionInputs;
    }

    public List<Symbol> rightJoinConditionInputs() {
        return this.rightJoinConditionInputs;
    }

    public Collection<DataType<?>> leftOutputTypes() {
        return this.leftOutputTypes;
    }

    public long estimatedRowSizeForLeft() {
        return this.estimatedRowSizeForLeft;
    }

    public long numberOfRowsForLeft() {
        return this.numberOfRowsForLeft;
    }
}

