/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.analyze.CopyFromParserProperties;
import io.crate.execution.dsl.phases.AbstractProjectionsPhase;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.distribution.DistributionInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FileUriCollectPhase
extends AbstractProjectionsPhase
implements CollectPhase {
    private final Collection<String> executionNodes;
    private final Symbol targetUri;
    private final List<Symbol> toCollect;
    private final CopyFromParserProperties parserProperties;
    private final String compression;
    private final Boolean sharedStorage;
    private DistributionInfo distributionInfo = DistributionInfo.DEFAULT_BROADCAST;
    private final InputFormat inputFormat;

    public FileUriCollectPhase(UUID jobId, int phaseId, String name, Collection<String> executionNodes, Symbol targetUri, List<Symbol> toCollect, List<Projection> projections, String compression, Boolean sharedStorage, CopyFromParserProperties parserProperties, InputFormat inputFormat) {
        super(jobId, phaseId, name, projections);
        this.executionNodes = executionNodes;
        this.targetUri = targetUri;
        this.toCollect = toCollect;
        this.compression = compression;
        this.sharedStorage = sharedStorage;
        this.parserProperties = parserProperties;
        this.inputFormat = inputFormat;
        this.outputTypes = FileUriCollectPhase.extractOutputTypes(toCollect, projections);
    }

    public Symbol targetUri() {
        return this.targetUri;
    }

    @Override
    public Collection<String> nodeIds() {
        return this.executionNodes;
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitFileUriCollectPhase(this, context);
    }

    @Override
    public List<Symbol> toCollect() {
        return this.toCollect;
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.FILE_URI_COLLECT;
    }

    @Nullable
    public String compression() {
        return this.compression;
    }

    public InputFormat inputFormat() {
        return this.inputFormat;
    }

    public CopyFromParserProperties parserProperties() {
        return this.parserProperties;
    }

    public FileUriCollectPhase(StreamInput in) throws IOException {
        super(in);
        this.compression = in.readOptionalString();
        this.sharedStorage = in.readOptionalBoolean();
        this.targetUri = Symbols.fromStream(in);
        int numNodes = in.readVInt();
        ArrayList<String> nodes = new ArrayList<String>(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            nodes.add(in.readString());
        }
        this.executionNodes = nodes;
        this.toCollect = Symbols.listFromStream(in);
        this.inputFormat = InputFormat.values()[in.readVInt()];
        this.parserProperties = in.getVersion().onOrAfter(Version.V_4_4_0) ? new CopyFromParserProperties(in) : CopyFromParserProperties.DEFAULT;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.compression);
        out.writeOptionalBoolean(this.sharedStorage);
        Symbols.toStream(this.targetUri, out);
        out.writeVInt(this.executionNodes.size());
        for (String node : this.executionNodes) {
            out.writeString(node);
        }
        Symbols.toStream(this.toCollect, out);
        out.writeVInt(this.inputFormat.ordinal());
        if (out.getVersion().onOrAfter(Version.V_4_4_0)) {
            this.parserProperties.writeTo(out);
        }
    }

    @Nullable
    public Boolean sharedStorage() {
        return this.sharedStorage;
    }

    @Override
    public DistributionInfo distributionInfo() {
        return this.distributionInfo;
    }

    @Override
    public void distributionInfo(DistributionInfo distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileUriCollectPhase that = (FileUriCollectPhase)o;
        return Objects.equals(this.executionNodes, that.executionNodes) && Objects.equals(this.targetUri, that.targetUri) && Objects.equals(this.toCollect, that.toCollect) && Objects.equals(this.parserProperties, that.parserProperties) && Objects.equals(this.compression, that.compression) && Objects.equals(this.sharedStorage, that.sharedStorage) && Objects.equals(this.distributionInfo, that.distributionInfo) && this.inputFormat == that.inputFormat;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.executionNodes, this.targetUri, this.toCollect, this.parserProperties, this.compression, this.sharedStorage, this.distributionInfo, this.inputFormat});
    }

    @Override
    public String toString() {
        return "FileUriCollectPhase{executionNodes=" + this.executionNodes + ", targetUri=" + this.targetUri + ", toCollect=" + this.toCollect + ", parserProperties=" + this.parserProperties + ", compression='" + this.compression + "', sharedStorage=" + this.sharedStorage + ", distributionInfo=" + this.distributionInfo + ", inputFormat=" + this.inputFormat + "}";
    }

    public static enum InputFormat {
        JSON,
        CSV;

    }
}

