/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.UpstreamPhase;
import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ExecutionPhases {
    public static boolean executesOnHandler(String handlerNode, Collection<String> executionNodes) {
        switch (executionNodes.size()) {
            case 0: {
                return true;
            }
            case 1: {
                return executionNodes.iterator().next().equals(handlerNode);
            }
        }
        return false;
    }

    public static ExecutionPhase fromStream(StreamInput in) throws IOException {
        return ExecutionPhase.Type.VALUES.get(in.readVInt()).fromStream(in);
    }

    public static void toStream(StreamOutput out, ExecutionPhase node) throws IOException {
        out.writeVInt(node.type().ordinal());
        node.writeTo(out);
    }

    public static boolean hasDirectResponseDownstream(Collection<String> downstreamNodes) {
        for (String nodeId : downstreamNodes) {
            if (!nodeId.equals("_response")) continue;
            return true;
        }
        return false;
    }

    public static String debugPrint(ExecutionPhase phase) {
        StringBuilder sb = new StringBuilder("phase{id=");
        sb.append(phase.phaseId());
        sb.append("/");
        sb.append(phase.name());
        sb.append(", ");
        sb.append("nodes=");
        sb.append(phase.nodeIds());
        if (phase instanceof UpstreamPhase) {
            UpstreamPhase uPhase = (UpstreamPhase)phase;
            sb.append(", dist=");
            sb.append((Object)uPhase.distributionInfo().distributionType());
        }
        sb.append("}");
        return sb.toString();
    }
}

