/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.UpstreamPhase;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.Routing;
import io.crate.planner.distribution.DistributionInfo;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class CountPhase
implements UpstreamPhase {
    private final int executionPhaseId;
    private final Routing routing;
    private final Symbol where;
    private DistributionInfo distributionInfo;

    public CountPhase(int executionPhaseId, Routing routing, Symbol where, DistributionInfo distributionInfo) {
        this.executionPhaseId = executionPhaseId;
        this.routing = routing;
        this.where = where;
        this.distributionInfo = distributionInfo;
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.COUNT;
    }

    @Override
    public String name() {
        return "count";
    }

    public Routing routing() {
        return this.routing;
    }

    public Symbol where() {
        return this.where;
    }

    @Override
    public int phaseId() {
        return this.executionPhaseId;
    }

    public Set<String> nodeIds() {
        return this.routing.nodes();
    }

    @Override
    public DistributionInfo distributionInfo() {
        return this.distributionInfo;
    }

    @Override
    public void distributionInfo(DistributionInfo distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitCountPhase(this, context);
    }

    public CountPhase(StreamInput in) throws IOException {
        this.executionPhaseId = in.readVInt();
        this.routing = new Routing(in);
        this.where = Symbols.fromStream(in);
        this.distributionInfo = new DistributionInfo(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.executionPhaseId);
        this.routing.writeTo(out);
        Symbols.toStream(this.where, out);
        this.distributionInfo.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountPhase that = (CountPhase)o;
        return this.executionPhaseId == that.executionPhaseId && Objects.equals(this.routing, that.routing) && Objects.equals(this.where, that.where) && Objects.equals(this.distributionInfo, that.distributionInfo);
    }

    public int hashCode() {
        return Objects.hash(this.executionPhaseId, this.routing, this.where, this.distributionInfo);
    }
}

