/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.iterable.Iterables;

public abstract class AbstractProjectionsPhase
implements ExecutionPhase {
    private UUID jobId;
    private int executionPhaseId;
    private String name;
    protected List<Projection> projections = List.of();
    protected List<DataType<?>> outputTypes = List.of();

    protected AbstractProjectionsPhase(UUID jobId, int executionPhaseId, String name, List<Projection> projections) {
        this.jobId = jobId;
        this.executionPhaseId = executionPhaseId;
        this.name = name;
        this.projections = projections;
    }

    protected static List<DataType<?>> extractOutputTypes(List<Symbol> outputs, List<Projection> projections) {
        if (projections.isEmpty()) {
            return Symbols.typeView(outputs);
        }
        Projection lastProjection = Iterables.get(projections, projections.size() - 1);
        return Symbols.typeView(lastProjection.outputs());
    }

    @Override
    public String name() {
        return this.name;
    }

    public UUID jobId() {
        return this.jobId;
    }

    @Override
    public int phaseId() {
        return this.executionPhaseId;
    }

    public boolean hasProjections() {
        return this.projections != null && this.projections.size() > 0;
    }

    public List<Projection> projections() {
        return this.projections;
    }

    public void addProjection(Projection projection) {
        ArrayList<Projection> projections = new ArrayList<Projection>(this.projections);
        projections.add(projection);
        this.projections = List.copyOf(projections);
        this.outputTypes = Symbols.typeView(projection.outputs());
    }

    public Optional<Projection> finalProjection() {
        if (this.projections.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(this.projections.get(this.projections.size() - 1));
    }

    public List<DataType<?>> outputTypes() {
        return this.outputTypes;
    }

    protected AbstractProjectionsPhase(StreamInput in) throws IOException {
        int numProjections;
        this.name = in.readString();
        this.jobId = new UUID(in.readLong(), in.readLong());
        this.executionPhaseId = in.readVInt();
        int numCols = in.readVInt();
        if (numCols > 0) {
            this.outputTypes = new ArrayList(numCols);
            for (int i = 0; i < numCols; ++i) {
                this.outputTypes.add(DataTypes.fromStream(in));
            }
        }
        if ((numProjections = in.readVInt()) > 0) {
            this.projections = new ArrayList<Projection>(numProjections);
            for (int i = 0; i < numProjections; ++i) {
                this.projections.add(Projection.fromStream(in));
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        assert (this.jobId != null) : "jobId must not be null";
        out.writeLong(this.jobId.getMostSignificantBits());
        out.writeLong(this.jobId.getLeastSignificantBits());
        out.writeVInt(this.executionPhaseId);
        int numCols = this.outputTypes.size();
        out.writeVInt(numCols);
        for (int i = 0; i < numCols; ++i) {
            DataTypes.toStream(this.outputTypes.get(i), out);
        }
        if (this.hasProjections()) {
            out.writeVInt(this.projections.size());
            for (Projection p : this.projections) {
                Projection.toStream(p, out);
            }
        } else {
            out.writeVInt(0);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractProjectionsPhase node = (AbstractProjectionsPhase)o;
        return !(this.name == null ? node.name != null : !this.name.equals(node.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "AbstractProjectionsPhase{name=" + this.name + ", projections=" + this.projections + ", outputTypes=" + this.outputTypes + "}";
    }
}

