/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.common.collections.Maps;
import io.crate.data.Input;
import io.crate.execution.dml.upsert.CheckConstraints;
import io.crate.execution.dml.upsert.GeneratedColumns;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.BaseImplementationSymbolVisitor;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.Doc;
import io.crate.expression.reference.DocRefResolver;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class UpdateSourceGen {
    private final Evaluator eval;
    private final GeneratedColumns<Doc> generatedColumns;
    private final ArrayList<Reference> updateColumns;
    private final CheckConstraints<Doc, CollectExpression<Doc, ?>> checks;

    UpdateSourceGen(TransactionContext txnCtx, NodeContext nodeCtx, DocTableInfo table, String[] updateColumns) {
        DocRefResolver refResolver = new DocRefResolver(table.partitionedBy());
        this.eval = new Evaluator(txnCtx, nodeCtx, refResolver);
        InputFactory inputFactory = new InputFactory(nodeCtx);
        this.checks = new CheckConstraints(txnCtx, inputFactory, refResolver, table);
        this.updateColumns = new ArrayList(updateColumns.length);
        for (String updateColumn : updateColumns) {
            ColumnIdent column = ColumnIdent.fromPath(updateColumn);
            Reference ref = table.getReference(column);
            this.updateColumns.add(ref == null ? table.getDynamic(column, true) : ref);
        }
        this.generatedColumns = table.generatedColumns().isEmpty() ? GeneratedColumns.empty() : new GeneratedColumns(inputFactory, txnCtx, GeneratedColumns.Validation.VALUE_MATCH, refResolver, this.updateColumns, table.generatedColumns());
    }

    Map<String, Object> generateSource(Doc result, Symbol[] updateAssignments, Object[] insertValues) {
        Values values = new Values(result, insertValues);
        HashMap<String, Object> updatedSource = new HashMap<String, Object>(result.getSource());
        Doc updatedDoc = result.withUpdatedSource(updatedSource);
        for (int i = 0; i < this.updateColumns.size(); ++i) {
            Reference ref = this.updateColumns.get(i);
            Object value = ((Input)updateAssignments[i].accept(this.eval, values)).value();
            ColumnIdent column = ref.column();
            Maps.mergeInto(updatedSource, column.name(), column.path(), value);
        }
        this.generatedColumns.setNextRow(updatedDoc);
        this.generatedColumns.validateValues(updatedSource);
        this.injectGeneratedColumns(updatedSource);
        this.checks.validate(updatedDoc);
        return updatedSource;
    }

    private void injectGeneratedColumns(HashMap<String, Object> updatedSource) {
        for (Map.Entry<Reference, Input<?>> entry : this.generatedColumns.generatedToInject()) {
            ColumnIdent column = entry.getKey().column();
            Object value = entry.getValue().value();
            Maps.mergeInto(updatedSource, column.name(), column.path(), value);
        }
    }

    private static class Evaluator
    extends BaseImplementationSymbolVisitor<Values> {
        private final ReferenceResolver<CollectExpression<Doc, ?>> refResolver;

        private Evaluator(TransactionContext txnCtx, NodeContext nodeCtx, ReferenceResolver<CollectExpression<Doc, ?>> refResolver) {
            super(txnCtx, nodeCtx);
            this.refResolver = refResolver;
        }

        @Override
        public Input<?> visitInputColumn(InputColumn inputColumn, Values context) {
            return Literal.ofUnchecked(inputColumn.valueType(), context.insertValues[inputColumn.index()]);
        }

        @Override
        public Input<?> visitReference(Reference symbol, Values values) {
            CollectExpression<Doc, ?> expr = this.refResolver.getImplementation(symbol);
            expr.setNextRow(values.getResult);
            return expr;
        }
    }

    private static class Values {
        private final Doc getResult;
        private final Object[] insertValues;

        Values(Doc getResult, Object[] insertValues) {
            this.getResult = getResult;
            this.insertValues = insertValues;
        }
    }
}

