/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.exceptions.Exceptions;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.ddl.SchemaUpdateClient;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.dml.TransportShardAction;
import io.crate.execution.dml.upsert.FromRawInsertSource;
import io.crate.execution.dml.upsert.GeneratedColumns;
import io.crate.execution.dml.upsert.InsertSourceGen;
import io.crate.execution.dml.upsert.ReturnValueGen;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.dml.upsert.UpdateSourceGen;
import io.crate.execution.engine.collect.PKLookupOperation;
import io.crate.execution.jobs.TasksService;
import io.crate.expression.reference.Doc;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportShardUpsertAction
extends TransportShardAction<ShardUpsertRequest, ShardUpsertRequest.Item> {
    private static final String ACTION_NAME = "internal:crate:sql/data/write";
    private static final int MAX_RETRY_LIMIT = 100000;
    private final Schemas schemas;
    private final NodeContext nodeCtx;

    @Inject
    public TransportShardUpsertAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SchemaUpdateClient schemaUpdateClient, TasksService tasksService, IndicesService indicesService, ShardStateAction shardStateAction, NodeContext nodeCtx, Schemas schemas) {
        super(ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, ShardUpsertRequest::new, schemaUpdateClient);
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
        tasksService.addListener(this);
    }

    @Override
    protected TransportWriteAction.WritePrimaryResult<ShardUpsertRequest, ShardResponse> processRequestItems(IndexShard indexShard, ShardUpsertRequest request, AtomicBoolean killed) {
        ShardResponse shardResponse = new ShardResponse(request.returnValues());
        String indexName = request.index();
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.getTableInfo(RelationName.fromIndexName(indexName), Operation.INSERT);
        Reference[] insertColumns = request.insertColumns();
        GeneratedColumns.Validation valueValidation = request.validateConstraints() ? GeneratedColumns.Validation.VALUE_MATCH : GeneratedColumns.Validation.NONE;
        TransactionContext txnCtx = TransactionContext.of(request.sessionSettings());
        InsertSourceGen insertSourceGen = insertColumns == null ? null : InsertSourceGen.of(txnCtx, this.nodeCtx, tableInfo, indexName, valueValidation, Arrays.asList(insertColumns));
        UpdateSourceGen updateSourceGen = request.updateColumns() == null ? null : new UpdateSourceGen(txnCtx, this.nodeCtx, tableInfo, request.updateColumns());
        ReturnValueGen returnValueGen = request.returnValues() == null ? null : new ReturnValueGen(txnCtx, this.nodeCtx, tableInfo, request.returnValues());
        Translog.Location translogLocation = null;
        for (ShardUpsertRequest.Item item : request.items()) {
            int location = item.location();
            if (killed.get()) {
                shardResponse.failure(new InterruptedException());
                break;
            }
            try {
                IndexItemResponse indexItemResponse = this.indexItem(request, item, indexShard, updateSourceGen, insertSourceGen, returnValueGen);
                if (indexItemResponse == null) continue;
                if (indexItemResponse.translog != null) {
                    shardResponse.add(location);
                    translogLocation = indexItemResponse.translog;
                }
                if (indexItemResponse.returnValues == null) continue;
                shardResponse.addResultRows(indexItemResponse.returnValues);
            }
            catch (Exception e) {
                if (this.retryPrimaryException(e)) {
                    throw Exceptions.toRuntimeException(e);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Failed to execute upsert shardId={} id={} error={}", (Object)request.shardId(), (Object)item.id(), (Object)e);
                }
                item.source(null);
                if (!request.continueOnError()) {
                    shardResponse.failure(e);
                    break;
                }
                shardResponse.add(location, new ShardResponse.Failure(item.id(), SQLExceptions.userFriendlyCrateExceptionTopOnly(e), e instanceof VersionConflictEngineException));
            }
        }
        return new TransportWriteAction.WritePrimaryResult<ShardUpsertRequest, ShardResponse>(request, shardResponse, translogLocation, null, indexShard);
    }

    @Override
    protected TransportWriteAction.WriteReplicaResult<ShardUpsertRequest> processRequestItemsOnReplica(IndexShard indexShard, ShardUpsertRequest request) throws IOException {
        Translog.Location location = null;
        for (ShardUpsertRequest.Item item : request.items()) {
            if (item.source() == null) {
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("[{} (R)] Document with id {}, has no source, primary operation must have failed", (Object)indexShard.shardId(), (Object)item.id());
                continue;
            }
            SourceToParse sourceToParse = new SourceToParse(indexShard.shardId().getIndexName(), item.id(), item.source(), XContentType.JSON);
            Engine.IndexResult indexResult = indexShard.applyIndexOperationOnReplica(item.seqNo(), item.primaryTerm(), item.version(), -1L, false, sourceToParse);
            if (indexResult.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new TransportReplicationAction.RetryOnReplicaException(indexShard.shardId(), "Mappings are not available on the replica yet, triggered update: " + indexResult.getRequiredMappingUpdate());
            }
            location = indexResult.getTranslogLocation();
        }
        return new TransportWriteAction.WriteReplicaResult<ShardUpsertRequest>(request, location, null, indexShard, this.logger);
    }

    @Nullable
    private IndexItemResponse indexItem(ShardUpsertRequest request, ShardUpsertRequest.Item item, IndexShard indexShard, @Nullable UpdateSourceGen updateSourceGen, @Nullable InsertSourceGen insertSourceGen, @Nullable ReturnValueGen returnValueGen) throws Exception {
        VersionConflictEngineException lastException = null;
        boolean tryInsertFirst = item.insertValues() != null;
        for (int retryCount = 0; retryCount < 100000; ++retryCount) {
            try {
                boolean isRetry;
                boolean bl = isRetry = retryCount > 0;
                if (tryInsertFirst) {
                    return this.insert(request, item, indexShard, isRetry, returnValueGen, insertSourceGen);
                }
                return this.update(item, indexShard, isRetry, returnValueGen, updateSourceGen);
            }
            catch (VersionConflictEngineException e) {
                lastException = e;
                if (request.duplicateKeyAction() == ShardUpsertRequest.DuplicateKeyAction.IGNORE) {
                    item.source(null);
                    return null;
                }
                Symbol[] updateAssignments = item.updateAssignments();
                if (updateAssignments != null && updateAssignments.length > 0) {
                    if (tryInsertFirst) {
                        tryInsertFirst = false;
                        continue;
                    }
                    if (item.retryOnConflict()) {
                        if (!this.logger.isTraceEnabled()) continue;
                        this.logger.trace("[{}] VersionConflict, retrying operation for document id={}, version={} retryCount={}", (Object)indexShard.shardId(), (Object)item.id(), (Object)item.version(), (Object)retryCount);
                        continue;
                    }
                }
                throw e;
            }
        }
        this.logger.warn("[{}] VersionConflict for document id={}, version={} exceeded retry limit of {}, will stop retrying", (Object)indexShard.shardId(), (Object)item.id(), (Object)item.version(), (Object)100000);
        throw lastException;
    }

    @VisibleForTesting
    protected IndexItemResponse insert(ShardUpsertRequest request, ShardUpsertRequest.Item item, IndexShard indexShard, boolean isRetry, @Nullable ReturnValueGen returnGen, InsertSourceGen insertSourceGen) throws Exception {
        BytesReference rawSource;
        assert (insertSourceGen != null) : "InsertSourceGen must not be null";
        Map<String, Object> source = null;
        try {
            if (insertSourceGen instanceof FromRawInsertSource) {
                rawSource = insertSourceGen.generateSourceAndCheckConstraintsAsBytesReference(item.insertValues());
            } else {
                source = insertSourceGen.generateSourceAndCheckConstraints(item.insertValues());
                rawSource = BytesReference.bytes(XContentFactory.jsonBuilder().map(source));
            }
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
        item.source(rawSource);
        long version = request.duplicateKeyAction() == ShardUpsertRequest.DuplicateKeyAction.OVERWRITE ? -3L : -4L;
        long seqNo = -2L;
        long primaryTerm = 0L;
        Engine.IndexResult indexResult = this.index(item, indexShard, isRetry, seqNo, primaryTerm, version);
        Object[] returnvalues = null;
        if (returnGen != null) {
            if (source == null) {
                source = JsonXContent.JSON_XCONTENT.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, BytesReference.toBytes(rawSource)).map();
            }
            returnvalues = returnGen.generateReturnValues(new Doc(-1, indexShard.shardId().getIndexName(), item.id(), indexResult.getVersion(), indexResult.getSeqNo(), indexResult.getTerm(), source, rawSource::utf8ToString));
        }
        return new IndexItemResponse(indexResult.getTranslogLocation(), returnvalues);
    }

    protected IndexItemResponse update(ShardUpsertRequest.Item item, IndexShard indexShard, boolean isRetry, @Nullable ReturnValueGen returnGen, UpdateSourceGen updateSourceGen) throws Exception {
        assert (updateSourceGen != null) : "UpdateSourceGen must not be null";
        Doc fetchedDoc = TransportShardUpsertAction.getDocument(indexShard, item.id(), item.version(), item.seqNo(), item.primaryTerm());
        Map<String, Object> source = updateSourceGen.generateSource(fetchedDoc, item.updateAssignments(), item.insertValues());
        BytesReference rawSource = BytesReference.bytes(XContentFactory.jsonBuilder().map(source));
        item.source(rawSource);
        long seqNo = item.seqNo();
        long primaryTerm = item.primaryTerm();
        long version = -3L;
        Engine.IndexResult indexResult = this.index(item, indexShard, isRetry, seqNo, primaryTerm, version);
        Object[] returnvalues = null;
        if (returnGen != null) {
            returnvalues = returnGen.generateReturnValues(new Doc(fetchedDoc.docId(), fetchedDoc.getIndex(), fetchedDoc.getId(), indexResult.getVersion(), indexResult.getSeqNo(), indexResult.getTerm(), source, rawSource::utf8ToString));
        }
        return new IndexItemResponse(indexResult.getTranslogLocation(), returnvalues);
    }

    private Engine.IndexResult index(ShardUpsertRequest.Item item, IndexShard indexShard, boolean isRetry, long seqNo, long primaryTerm, long version) throws Exception {
        SourceToParse sourceToParse = new SourceToParse(indexShard.shardId().getIndexName(), item.id(), item.source(), XContentType.JSON);
        Engine.IndexResult indexResult = this.executeOnPrimaryHandlingMappingUpdate(indexShard.shardId(), () -> indexShard.applyIndexOperationOnPrimary(version, VersionType.INTERNAL, sourceToParse, seqNo, primaryTerm, -1L, isRetry), e -> indexShard.getFailedIndexResult((Exception)e, -3L));
        switch (indexResult.getResultType()) {
            case SUCCESS: {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("SUCCESS - id={}, primary_term={}, seq_no={}", (Object)item.id(), (Object)primaryTerm, (Object)indexResult.getSeqNo());
                }
                item.seqNo(indexResult.getSeqNo());
                item.version(indexResult.getVersion());
                item.primaryTerm(indexResult.getTerm());
                return indexResult;
            }
            case FAILURE: {
                Exception failure = indexResult.getFailure();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("FAILURE - id={}, primary_term={}, seq_no={}", (Object)item.id(), (Object)primaryTerm, (Object)indexResult.getSeqNo());
                }
                assert (failure != null) : "Failure must not be null if resultType is FAILURE";
                throw failure;
            }
        }
        throw new AssertionError((Object)"IndexResult must either succeed or fail. Required mapping updates must have been handled.");
    }

    private static Doc getDocument(IndexShard indexShard, String id, long version, long seqNo, long primaryTerm) {
        Doc doc = PKLookupOperation.lookupDoc(indexShard, id, -3L, VersionType.INTERNAL, seqNo, primaryTerm);
        if (doc == null) {
            throw new DocumentMissingException(indexShard.shardId(), "default", id);
        }
        if (doc.getSource() == null) {
            throw new DocumentSourceMissingException(indexShard.shardId(), "default", id);
        }
        if (version != -3L && version != doc.getVersion()) {
            throw new VersionConflictEngineException(indexShard.shardId(), id, "Requested version: " + version + " but got version: " + doc.getVersion());
        }
        return doc;
    }

    public static Collection<ColumnIdent> getNotUsedNonGeneratedColumns(Reference[] targetColumns, DocTableInfo tableInfo) {
        HashSet<String> targetColumnsSet = new HashSet<String>();
        ArrayList<ColumnIdent> columnsNotUsed = new ArrayList<ColumnIdent>();
        if (targetColumns != null) {
            for (Reference targetColumn : targetColumns) {
                targetColumnsSet.add(targetColumn.column().fqn());
            }
        }
        for (Reference reference : tableInfo.columns()) {
            if (reference.isNullable() || reference instanceof GeneratedReference || reference.defaultExpression() != null || targetColumnsSet.contains(reference.column().fqn())) continue;
            columnsNotUsed.add(reference.column());
        }
        return columnsNotUsed;
    }

    static class IndexItemResponse {
        @Nullable
        final Translog.Location translog;
        @Nullable
        final Object[] returnValues;

        IndexItemResponse(@Nullable Translog.Location translog, @Nullable Object[] returnValues) {
            this.translog = translog;
            this.returnValues = returnValues;
        }
    }
}

