/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.Streamer;
import io.crate.common.unit.TimeValue;
import io.crate.execution.dml.ShardRequest;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.Reference;
import io.crate.metadata.settings.SessionSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public final class ShardUpsertRequest
extends ShardRequest<ShardUpsertRequest, Item> {
    private DuplicateKeyAction duplicateKeyAction;
    private boolean continueOnError;
    private boolean validateConstraints = true;
    private SessionSettings sessionSettings;
    @Nullable
    private String[] updateColumns;
    @Nullable
    private Reference[] insertColumns;
    @Nullable
    private Symbol[] returnValues;

    public ShardUpsertRequest(ShardId shardId, UUID jobId, boolean continueOnError, boolean validateConstraints, DuplicateKeyAction duplicateKeyAction, SessionSettings sessionSettings, @Nullable String[] updateColumns, @Nullable Reference[] insertColumns, @Nullable Symbol[] returnValues) {
        super(shardId, jobId);
        assert (updateColumns != null || insertColumns != null) : "Missing updateAssignments, whether for update nor for insert";
        this.continueOnError = continueOnError;
        this.validateConstraints = validateConstraints;
        this.duplicateKeyAction = duplicateKeyAction;
        this.sessionSettings = sessionSettings;
        this.updateColumns = updateColumns;
        this.insertColumns = insertColumns;
        this.returnValues = returnValues;
    }

    public ShardUpsertRequest(StreamInput in) throws IOException {
        super(in);
        int returnValuesSize;
        int assignmentsColumnsSize = in.readVInt();
        if (assignmentsColumnsSize > 0) {
            this.updateColumns = new String[assignmentsColumnsSize];
            for (int i = 0; i < assignmentsColumnsSize; ++i) {
                this.updateColumns[i] = in.readString();
            }
        }
        int missingAssignmentsColumnsSize = in.readVInt();
        Streamer[] insertValuesStreamer = null;
        if (missingAssignmentsColumnsSize > 0) {
            this.insertColumns = new Reference[missingAssignmentsColumnsSize];
            for (int i = 0; i < missingAssignmentsColumnsSize; ++i) {
                this.insertColumns[i] = Reference.fromStream(in);
            }
            insertValuesStreamer = Symbols.streamerArray(List.of(this.insertColumns));
        }
        this.continueOnError = in.readBoolean();
        this.duplicateKeyAction = DuplicateKeyAction.values()[in.readVInt()];
        this.validateConstraints = in.readBoolean();
        this.sessionSettings = new SessionSettings(in);
        int numItems = in.readVInt();
        this.items = new ArrayList(numItems);
        for (int i = 0; i < numItems; ++i) {
            this.items.add(new Item(in, insertValuesStreamer));
        }
        if (in.getVersion().onOrAfter(Version.V_4_2_0) && (returnValuesSize = in.readVInt()) > 0) {
            this.returnValues = new Symbol[returnValuesSize];
            for (int i = 0; i < returnValuesSize; ++i) {
                this.returnValues[i] = Symbols.fromStream(in);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.updateColumns != null) {
            out.writeVInt(this.updateColumns.length);
            for (String column : this.updateColumns) {
                out.writeString(column);
            }
        } else {
            out.writeVInt(0);
        }
        Streamer[] insertValuesStreamer = null;
        if (this.insertColumns != null) {
            out.writeVInt(this.insertColumns.length);
            for (Reference reference : this.insertColumns) {
                Reference.toStream(reference, out);
            }
            insertValuesStreamer = Symbols.streamerArray(List.of(this.insertColumns));
        } else {
            out.writeVInt(0);
        }
        out.writeBoolean(this.continueOnError);
        out.writeVInt(this.duplicateKeyAction.ordinal());
        out.writeBoolean(this.validateConstraints);
        this.sessionSettings.writeTo(out);
        out.writeVInt(this.items.size());
        for (Item item : this.items) {
            item.writeTo(out, insertValuesStreamer);
        }
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            if (this.returnValues != null) {
                out.writeVInt(this.returnValues.length);
                for (Symbol returnValue : this.returnValues) {
                    Symbols.toStream(returnValue, out);
                }
            } else {
                out.writeVInt(0);
            }
        }
    }

    @Nullable
    public SessionSettings sessionSettings() {
        return this.sessionSettings;
    }

    @Nullable
    public Symbol[] returnValues() {
        return this.returnValues;
    }

    @Nullable
    public String[] updateColumns() {
        return this.updateColumns;
    }

    @Nullable
    public Reference[] insertColumns() {
        return this.insertColumns;
    }

    public boolean continueOnError() {
        return this.continueOnError;
    }

    public boolean validateConstraints() {
        return this.validateConstraints;
    }

    public DuplicateKeyAction duplicateKeyAction() {
        return this.duplicateKeyAction;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShardUpsertRequest items = (ShardUpsertRequest)o;
        return this.continueOnError == items.continueOnError && this.validateConstraints == items.validateConstraints && Objects.equals(this.sessionSettings, items.sessionSettings) && this.duplicateKeyAction == items.duplicateKeyAction && Arrays.equals(this.updateColumns, items.updateColumns) && Arrays.equals(this.insertColumns, items.insertColumns) && Arrays.equals(this.returnValues, items.returnValues);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(new Object[]{super.hashCode(), this.sessionSettings, this.duplicateKeyAction, this.continueOnError, this.validateConstraints});
        result = 31 * result + Arrays.hashCode(this.updateColumns);
        result = 31 * result + Arrays.hashCode(this.insertColumns);
        result = 31 * result + Arrays.hashCode(this.returnValues);
        return result;
    }

    public static enum DuplicateKeyAction {
        UPDATE_OR_FAIL,
        OVERWRITE,
        IGNORE;

    }

    public static final class Item
    extends ShardRequest.Item {
        @Nullable
        private BytesReference source;
        @Nullable
        private Symbol[] updateAssignments;
        @Nullable
        private Object[] insertValues;

        public Item(String id, @Nullable Symbol[] updateAssignments, @Nullable Object[] insertValues, @Nullable Long version, @Nullable Long seqNo, @Nullable Long primaryTerm) {
            super(id);
            this.updateAssignments = updateAssignments;
            if (version != null) {
                this.version = version;
            }
            if (seqNo != null) {
                this.seqNo = seqNo;
            }
            if (primaryTerm != null) {
                this.primaryTerm = primaryTerm;
            }
            this.insertValues = insertValues;
        }

        @Nullable
        public BytesReference source() {
            return this.source;
        }

        public void source(BytesReference source) {
            this.source = source;
        }

        boolean retryOnConflict() {
            return this.seqNo == -2L && this.version == -3L;
        }

        @Nullable
        Symbol[] updateAssignments() {
            return this.updateAssignments;
        }

        @Nullable
        public Object[] insertValues() {
            return this.insertValues;
        }

        public Item(StreamInput in, @Nullable Streamer[] insertValueStreamers) throws IOException {
            super(in);
            int missingAssignmentsSize;
            int i;
            if (in.readBoolean()) {
                int assignmentsSize = in.readVInt();
                this.updateAssignments = new Symbol[assignmentsSize];
                for (i = 0; i < assignmentsSize; ++i) {
                    this.updateAssignments[i] = Symbols.fromStream(in);
                }
            }
            if ((missingAssignmentsSize = in.readVInt()) > 0) {
                assert (insertValueStreamers != null) : "streamers are required if reading insert values";
                this.insertValues = new Object[missingAssignmentsSize];
                for (i = 0; i < missingAssignmentsSize; ++i) {
                    this.insertValues[i] = insertValueStreamers[i].readValueFrom(in);
                }
            }
            if (in.readBoolean()) {
                this.source = in.readBytesReference();
            }
        }

        public void writeTo(StreamOutput out, @Nullable Streamer[] insertValueStreamers) throws IOException {
            super.writeTo(out);
            if (this.updateAssignments != null) {
                out.writeBoolean(true);
                out.writeVInt(this.updateAssignments.length);
                for (Symbol updateAssignment : this.updateAssignments) {
                    Symbols.toStream(updateAssignment, out);
                }
            } else {
                out.writeBoolean(false);
            }
            if (this.insertValues != null) {
                assert (insertValueStreamers != null) : "streamers are required to stream insert values";
                out.writeVInt(this.insertValues.length);
                for (int i = 0; i < this.insertValues.length; ++i) {
                    insertValueStreamers[i].writeValueTo(out, this.insertValues[i]);
                }
            } else {
                out.writeVInt(0);
            }
            boolean sourceAvailable = this.source != null;
            out.writeBoolean(sourceAvailable);
            if (sourceAvailable) {
                out.writeBytesReference(this.source);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Item item = (Item)o;
            return Objects.equals(this.source, item.source) && Arrays.equals(this.updateAssignments, item.updateAssignments) && Arrays.equals(this.insertValues, item.insertValues);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(super.hashCode(), this.source);
            result = 31 * result + Arrays.hashCode(this.updateAssignments);
            result = 31 * result + Arrays.hashCode(this.insertValues);
            return result;
        }
    }

    public static class Builder {
        private final SessionSettings sessionSettings;
        private final TimeValue timeout;
        private final DuplicateKeyAction duplicateKeyAction;
        private final boolean continueOnError;
        @Nullable
        private final String[] assignmentsColumns;
        @Nullable
        private final Reference[] missingAssignmentsColumns;
        private final UUID jobId;
        private final boolean validateGeneratedColumns;
        @Nullable
        private final Symbol[] returnValues;

        public Builder(SessionSettings sessionSettings, TimeValue timeout, DuplicateKeyAction duplicateKeyAction, boolean continueOnError, @Nullable String[] assignmentsColumns, @Nullable Reference[] missingAssignmentsColumns, @Nullable Symbol[] returnValue, UUID jobId, boolean validateGeneratedColumns) {
            this.sessionSettings = sessionSettings;
            this.timeout = timeout;
            this.duplicateKeyAction = duplicateKeyAction;
            this.continueOnError = continueOnError;
            this.assignmentsColumns = assignmentsColumns;
            this.missingAssignmentsColumns = missingAssignmentsColumns;
            this.jobId = jobId;
            this.returnValues = returnValue;
            this.validateGeneratedColumns = validateGeneratedColumns;
        }

        public ShardUpsertRequest newRequest(ShardId shardId) {
            return (ShardUpsertRequest)new ShardUpsertRequest(shardId, this.jobId, this.continueOnError, this.validateGeneratedColumns, this.duplicateKeyAction, this.sessionSettings, this.assignmentsColumns, this.missingAssignmentsColumns, this.returnValues).timeout(this.timeout);
        }
    }
}

