/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.data.Input;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.Doc;
import io.crate.expression.reference.DocRefResolver;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import java.util.List;
import javax.annotation.Nullable;

final class ReturnValueGen {
    private final List<CollectExpression<Doc, ?>> expressions;
    private final List<Input<?>> inputs;

    ReturnValueGen(TransactionContext txnCtx, NodeContext nodeCtx, DocTableInfo table, Symbol[] returnValues) {
        InputFactory.Context cntx = new InputFactory(nodeCtx).ctxForRefs(txnCtx, new DocRefResolver(table.partitionedBy()));
        cntx.add(List.of(returnValues));
        this.expressions = cntx.expressions();
        this.inputs = cntx.topLevelInputs();
    }

    @Nullable
    Object[] generateReturnValues(Doc doc) {
        if (this.inputs.isEmpty()) {
            return null;
        }
        this.expressions.forEach(x -> x.setNextRow(doc));
        Object[] result = new Object[this.inputs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.inputs.get(i).value();
        }
        return result;
    }
}

