/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.execution.dml.upsert.FromRawInsertSource;
import io.crate.execution.dml.upsert.GeneratedColsFromRawInsertSource;
import io.crate.execution.dml.upsert.GeneratedColumns;
import io.crate.execution.dml.upsert.InsertSourceFromCells;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocSysColumns;
import io.crate.metadata.doc.DocTableInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentFactory;

public interface InsertSourceGen {
    default public BytesReference generateSourceAndCheckConstraintsAsBytesReference(Object[] values) throws IOException {
        return BytesReference.bytes(XContentFactory.jsonBuilder().map(this.generateSourceAndCheckConstraints(values)));
    }

    public Map<String, Object> generateSourceAndCheckConstraints(Object[] var1) throws IOException;

    public static InsertSourceGen of(TransactionContext txnCtx, NodeContext nodeCtx, DocTableInfo table, String indexName, GeneratedColumns.Validation validation, List<Reference> targets) {
        if (targets.size() == 1 && targets.get(0).column().equals(DocSysColumns.RAW)) {
            if (table.generatedColumns().isEmpty() && table.defaultExpressionColumns().isEmpty()) {
                return new FromRawInsertSource();
            }
            return new GeneratedColsFromRawInsertSource(txnCtx, nodeCtx, table.generatedColumns(), table.defaultExpressionColumns());
        }
        return new InsertSourceFromCells(txnCtx, nodeCtx, table, indexName, validation, targets);
    }
}

