/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists2;
import io.crate.common.collections.Maps;
import io.crate.common.collections.Tuple;
import io.crate.data.BiArrayRow;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.dml.upsert.CheckConstraints;
import io.crate.execution.dml.upsert.FromSourceRefResolver;
import io.crate.execution.dml.upsert.GeneratedColumns;
import io.crate.execution.dml.upsert.InsertSourceGen;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.InputCollectExpression;
import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.expression.InputFactory;
import io.crate.expression.ValueExtractors;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class InsertSourceFromCells
implements InsertSourceGen {
    private final List<Reference> targets;
    private final BiArrayRow row = new BiArrayRow();
    private final CheckConstraints<Map<String, Object>, CollectExpression<Map<String, Object>, ?>> checks;
    private final GeneratedColumns<Row> generatedColumns;
    private final Object[] defaultValues;
    private final List<Reference> partitionedByColumns;

    public InsertSourceFromCells(TransactionContext txnCtx, NodeContext nodeCtx, DocTableInfo table, String indexName, GeneratedColumns.Validation validation, List<Reference> targets) {
        Tuple<List<Reference>, Object[]> allTargetColumnsAndDefaults = InsertSourceFromCells.addDefaults(targets, table, txnCtx, nodeCtx);
        this.targets = allTargetColumnsAndDefaults.v1();
        this.defaultValues = allTargetColumnsAndDefaults.v2();
        this.partitionedByColumns = table.partitionedByColumns();
        ReferencesFromInputRow referenceResolver = new ReferencesFromInputRow(this.targets, table.partitionedByColumns(), indexName);
        InputFactory inputFactory = new InputFactory(nodeCtx);
        this.generatedColumns = table.generatedColumns().isEmpty() ? GeneratedColumns.empty() : new GeneratedColumns(inputFactory, txnCtx, validation, referenceResolver, this.targets, table.generatedColumns());
        this.checks = new CheckConstraints(txnCtx, inputFactory, new FromSourceRefResolver(table.partitionedByColumns(), indexName), table);
    }

    @Override
    public Map<String, Object> generateSourceAndCheckConstraints(Object[] values) {
        int i;
        this.row.firstCells(values);
        this.row.secondCells(this.defaultValues);
        HashMap<String, Object> source = new HashMap<String, Object>();
        for (i = 0; i < this.targets.size(); ++i) {
            Reference target = this.targets.get(i);
            Object valueForInsert = target.valueType().valueForInsert(this.row.get(i));
            ColumnIdent column = target.column();
            Maps.mergeInto(source, column.name(), column.path(), valueForInsert, Map::putIfAbsent);
        }
        for (i = 0; i < this.partitionedByColumns.size(); ++i) {
            Reference pCol = this.partitionedByColumns.get(i);
            ColumnIdent column = pCol.column();
            ArrayList<String> fullPath = new ArrayList<String>(1 + column.path().size());
            fullPath.add(column.name());
            fullPath.addAll(column.path());
            Maps.removeByPath(source, fullPath);
        }
        this.generatedColumns.setNextRow(this.row);
        this.generatedColumns.validateValues(source);
        for (Map.Entry<Reference, Input<?>> entry : this.generatedColumns.generatedToInject()) {
            Reference reference = entry.getKey();
            Object value = entry.getValue().value();
            Object valueForInsert = reference.valueType().valueForInsert(value);
            ColumnIdent column = reference.column();
            Maps.mergeInto(source, column.name(), column.path(), valueForInsert);
        }
        this.checks.validate(source);
        return source;
    }

    private static Tuple<List<Reference>, Object[]> addDefaults(List<Reference> targets, DocTableInfo table, TransactionContext txnCtx, NodeContext nodeCtx) {
        ArrayList<Reference> defaultColumns = new ArrayList<Reference>(table.defaultExpressionColumns().size());
        ArrayList<Object> defaultValues = new ArrayList<Object>();
        for (Reference ref : table.defaultExpressionColumns()) {
            if (targets.contains(ref)) continue;
            defaultColumns.add(ref);
            Object val = SymbolEvaluator.evaluateWithoutParams(txnCtx, nodeCtx, ref.defaultExpression());
            defaultValues.add(val);
        }
        List<Object> allColumns = defaultColumns.isEmpty() ? targets : Lists2.concat(targets, defaultColumns);
        return new Tuple<List<Reference>, Object[]>(allColumns, defaultValues.toArray(new Object[0]));
    }

    private static class ReferencesFromInputRow
    implements ReferenceResolver<CollectExpression<Row, ?>> {
        private final List<Reference> targets;
        private final List<Reference> partitionedBy;
        private final List<ColumnIdent> columns;
        @Nullable
        private final PartitionName partitionName;

        ReferencesFromInputRow(List<Reference> targets, List<Reference> partitionedBy, String indexName) {
            this.columns = Lists2.map(targets, Reference::column);
            this.targets = targets;
            this.partitionedBy = partitionedBy;
            this.partitionName = partitionedBy.isEmpty() ? null : PartitionName.fromIndexOrTemplate(indexName);
        }

        @Override
        public CollectExpression<Row, ?> getImplementation(Reference ref) {
            int idx = this.targets.indexOf(ref);
            if (idx >= 0) {
                return new InputCollectExpression(idx);
            }
            int rootIdx = this.columns.indexOf(ref.column().getRoot());
            if (rootIdx < 0) {
                int partitionPos = this.partitionedBy.indexOf(ref);
                if (partitionPos < 0) {
                    return NestableCollectExpression.constant(null);
                }
                assert (this.partitionName != null) : "If there was a match in `partitionedBy`, then partitionName must not be null";
                return NestableCollectExpression.constant(this.partitionName.values().get(partitionPos));
            }
            return NestableCollectExpression.forFunction(ValueExtractors.fromRow(rootIdx, ref.column().path()));
        }
    }
}

