/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.data.Input;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.InputFactory;
import io.crate.expression.ValueExtractors;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.types.DataType;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GeneratedColumns<T> {
    private static final GeneratedColumns EMPTY = new GeneratedColumns();
    private final Map<Reference, Input<?>> toValidate;
    private final Map<Reference, Input<?>> generatedToInject;
    private final List<CollectExpression<T, ?>> expressions;

    public static <T> GeneratedColumns<T> empty() {
        return EMPTY;
    }

    private GeneratedColumns() {
        this.toValidate = Collections.emptyMap();
        this.generatedToInject = Collections.emptyMap();
        this.expressions = Collections.emptyList();
    }

    GeneratedColumns(InputFactory inputFactory, TransactionContext txnCtx, Validation validation, ReferenceResolver<CollectExpression<T, ?>> refResolver, Collection<Reference> presentColumns, List<GeneratedReference> allGeneratedColumns) {
        InputFactory.Context<CollectExpression<T, ?>> ctx = inputFactory.ctxForRefs(txnCtx, refResolver);
        this.generatedToInject = new HashMap();
        for (GeneratedReference generatedCol : allGeneratedColumns) {
            if (presentColumns.contains(generatedCol)) continue;
            this.generatedToInject.put(generatedCol, ctx.add(generatedCol.generatedExpression()));
        }
        if (validation == Validation.VALUE_MATCH) {
            this.toValidate = new HashMap();
            for (GeneratedReference generatedCol : allGeneratedColumns) {
                if (generatedCol.column().isTopLevel() && this.generatedToInject.containsKey(generatedCol)) continue;
                this.toValidate.put(generatedCol, ctx.add(generatedCol.generatedExpression()));
            }
        } else {
            this.toValidate = Map.of();
        }
        this.expressions = ctx.expressions();
    }

    public void setNextRow(T row) {
        for (int i = 0; i < this.expressions.size(); ++i) {
            this.expressions.get(i).setNextRow(row);
        }
    }

    void validateValues(HashMap<String, Object> source) {
        for (Map.Entry<Reference, Input<?>> entry : this.toValidate.entrySet()) {
            Reference ref = entry.getKey();
            Object providedValue = ValueExtractors.fromMap(source, ref.column());
            if (providedValue == null && !ref.column().isTopLevel()) continue;
            Object generatedValue = entry.getValue().value();
            DataType<?> dataType = ref.valueType();
            if (Comparator.nullsFirst(dataType).compare(dataType.sanitizeValue(generatedValue), dataType.sanitizeValue(providedValue)) == 0) continue;
            throw new IllegalArgumentException("Given value " + providedValue + " for generated column " + ref.column() + " does not match calculation " + ((GeneratedReference)ref).formattedGeneratedExpression() + " = " + generatedValue);
        }
    }

    Iterable<? extends Map.Entry<Reference, Input<?>>> generatedToInject() {
        return this.generatedToInject.entrySet();
    }

    public static enum Validation {
        NONE,
        VALUE_MATCH;

    }
}

