/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Maps;
import io.crate.data.Input;
import io.crate.execution.dml.upsert.FromSourceRefResolver;
import io.crate.execution.dml.upsert.InsertSourceGen;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.InputFactory;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public final class GeneratedColsFromRawInsertSource
implements InsertSourceGen {
    private final Map<Reference, Input<?>> generatedCols;
    private final List<CollectExpression<Map<String, Object>, ?>> expressions;
    private final Map<Reference, Object> defaults;

    GeneratedColsFromRawInsertSource(TransactionContext txnCtx, NodeContext nodeCtx, List<GeneratedReference> generatedColumns, List<Reference> defaultExpressionColumns) {
        InputFactory inputFactory = new InputFactory(nodeCtx);
        InputFactory.Context ctx = inputFactory.ctxForRefs(txnCtx, FromSourceRefResolver.WITHOUT_PARTITIONED_BY_REFS);
        this.generatedCols = new HashMap(generatedColumns.size());
        generatedColumns.forEach(r -> this.generatedCols.put((Reference)r, ctx.add(r.generatedExpression())));
        this.expressions = ctx.expressions();
        this.defaults = this.buildDefaults(defaultExpressionColumns, txnCtx, nodeCtx);
    }

    @Override
    public Map<String, Object> generateSourceAndCheckConstraints(Object[] values) {
        String rawSource = (String)values[0];
        Map<String, Object> source = XContentHelper.toMap(new BytesArray(rawSource), XContentType.JSON);
        GeneratedColsFromRawInsertSource.mixinDefaults(source, this.defaults);
        for (int i = 0; i < this.expressions.size(); ++i) {
            this.expressions.get(i).setNextRow(source);
        }
        for (Map.Entry<Reference, Input<?>> entry : this.generatedCols.entrySet()) {
            Reference reference = entry.getKey();
            Object value = entry.getValue().value();
            Object valueForInsert = reference.valueType().valueForInsert(value);
            source.putIfAbsent(reference.column().fqn(), valueForInsert);
        }
        return source;
    }

    private Map<Reference, Object> buildDefaults(List<Reference> defaults, TransactionContext txnCtx, NodeContext nodeCtx) {
        HashMap<Reference, Object> m = new HashMap<Reference, Object>();
        for (Reference ref : defaults) {
            Object val = SymbolEvaluator.evaluateWithoutParams(txnCtx, nodeCtx, ref.defaultExpression());
            m.put(ref, val);
        }
        return m;
    }

    private static void mixinDefaults(Map<String, Object> source, Map<Reference, Object> defaults) {
        for (Map.Entry<Reference, Object> entry : defaults.entrySet()) {
            ColumnIdent column = entry.getKey().column();
            Maps.mergeInto(source, column.name(), column.path(), entry.getValue(), Map::putIfAbsent);
        }
    }
}

