/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.expression.ValueExtractors;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import java.util.List;
import java.util.Map;

class FromSourceRefResolver
implements ReferenceResolver<CollectExpression<Map<String, Object>, ?>> {
    static final FromSourceRefResolver WITHOUT_PARTITIONED_BY_REFS = new FromSourceRefResolver(List.of(), "");
    private final List<Reference> partitionedBy;
    private final PartitionName partitionName;

    FromSourceRefResolver(List<Reference> partitionedBy, String indexName) {
        this.partitionedBy = partitionedBy;
        this.partitionName = partitionedBy.isEmpty() ? null : PartitionName.fromIndexOrTemplate(indexName);
    }

    @Override
    public CollectExpression<Map<String, Object>, Object> getImplementation(Reference ref) {
        int partitionPos = this.partitionedBy.indexOf(ref);
        if (partitionPos >= 0 && !(ref instanceof GeneratedReference)) {
            return NestableCollectExpression.constant(this.partitionName.values().get(partitionPos));
        }
        return NestableCollectExpression.forFunction(ValueExtractors.fromMap(ref.column(), ref.valueType()));
    }
}

