/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.common.collections.Lists2;
import io.crate.common.collections.Tuple;
import io.crate.data.Input;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.sql.tree.CheckConstraint;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CheckConstraints<T, E extends CollectExpression<T, ?>> {
    private final List<Input<?>> inputs = new ArrayList();
    private final List<E> expressions;
    private final List<ColumnIdent> notNullColumns;
    private final List<Tuple<? extends Input<?>, CheckConstraint<Symbol>>> checkConstraints;

    CheckConstraints(TransactionContext txnCtx, InputFactory inputFactory, ReferenceResolver<E> refResolver, DocTableInfo table) {
        InputFactory.Context ctx = inputFactory.ctxForRefs(txnCtx, refResolver);
        this.notNullColumns = new ArrayList<ColumnIdent>(table.notNullColumns());
        for (int i = 0; i < this.notNullColumns.size(); ++i) {
            ColumnIdent columnIdent = this.notNullColumns.get(i);
            Reference notNullRef = table.getReadReference(columnIdent);
            assert (notNullRef != null) : "ColumnIdent retrieved via `table.notNullColumns` must be available via `table.getReadReference`";
            this.inputs.add(ctx.add(notNullRef));
        }
        this.expressions = ctx.expressions();
        this.checkConstraints = Lists2.map(table.checkConstraints(), chk -> new Tuple(ctx.add((Symbol)chk.expression()), (CheckConstraint)chk));
    }

    public void validate(T values) {
        int i;
        for (i = 0; i < this.expressions.size(); ++i) {
            ((CollectExpression)this.expressions.get(i)).setNextRow(values);
        }
        for (i = 0; i < this.inputs.size(); ++i) {
            Object val = this.inputs.get(i).value();
            if (val != null) continue;
            throw new IllegalArgumentException("\"" + this.notNullColumns.get(i) + "\" must not be null");
        }
        for (i = 0; i < this.checkConstraints.size(); ++i) {
            Tuple<Input<?>, CheckConstraint<Symbol>> checkEntry = this.checkConstraints.get(i);
            Input<?> checkInput = checkEntry.v1();
            Object value = checkInput.value();
            if (value == null) continue;
            assert (value instanceof Boolean) : "expected a boolean value";
            if (((Boolean)value).booleanValue()) continue;
            CheckConstraint<Symbol> chk = checkEntry.v2();
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Failed CONSTRAINT %s CHECK (%s) and values %s", chk.name(), chk.expressionStr(), values));
        }
    }
}

