/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.delete;

import io.crate.exceptions.Exceptions;
import io.crate.execution.ddl.SchemaUpdateClient;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.dml.TransportShardAction;
import io.crate.execution.dml.delete.ShardDeleteRequest;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportShardDeleteAction
extends TransportShardAction<ShardDeleteRequest, ShardDeleteRequest.Item> {
    private static final String ACTION_NAME = "internal:crate:sql/data/delete";

    @Inject
    public TransportShardDeleteAction(TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, SchemaUpdateClient schemaUpdateClient) {
        super(ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, ShardDeleteRequest::new, schemaUpdateClient);
    }

    @Override
    protected TransportWriteAction.WritePrimaryResult<ShardDeleteRequest, ShardResponse> processRequestItems(IndexShard indexShard, ShardDeleteRequest request, AtomicBoolean killed) throws IOException {
        ShardResponse shardResponse = new ShardResponse();
        Translog.Location translogLocation = null;
        boolean debugEnabled = this.logger.isDebugEnabled();
        for (ShardDeleteRequest.Item item : request.items()) {
            int location = item.location();
            if (killed.get()) {
                request.skipFromLocation(location);
                shardResponse.failure(new InterruptedException("Job killed"));
                break;
            }
            try {
                Engine.DeleteResult deleteResult = this.shardDeleteOperationOnPrimary(item, indexShard);
                translogLocation = deleteResult.getTranslogLocation();
                Exception failure = deleteResult.getFailure();
                if (failure == null) {
                    if (deleteResult.isFound()) {
                        if (debugEnabled) {
                            this.logger.debug("shardId={} successfully deleted id={}", (Object)request.shardId(), (Object)item.id());
                        }
                        shardResponse.add(location);
                        continue;
                    }
                    if (debugEnabled) {
                        this.logger.debug("shardId={} failed to execute delete for id={}, doc not found", (Object)request.shardId(), (Object)item.id());
                    }
                    shardResponse.add(location, new ShardResponse.Failure(item.id(), "Document not found while deleting", false));
                    continue;
                }
                if (debugEnabled) {
                    this.logger.debug("shardId={} failed to execute delete for id={}: {}", (Object)request.shardId(), (Object)item.id(), (Object)failure);
                }
                shardResponse.add(location, new ShardResponse.Failure(item.id(), Exceptions.userFriendlyMessageInclNested(failure), failure instanceof VersionConflictEngineException));
            }
            catch (Exception e) {
                if (!TransportActions.isShardNotAvailableException(e)) {
                    throw e;
                }
                if (debugEnabled) {
                    this.logger.debug("shardId={} failed to execute delete for id={}: {}", (Object)request.shardId(), (Object)item.id(), (Object)e);
                }
                shardResponse.add(location, new ShardResponse.Failure(item.id(), Exceptions.userFriendlyMessageInclNested(e), e instanceof VersionConflictEngineException));
            }
        }
        return new TransportWriteAction.WritePrimaryResult<ShardDeleteRequest, ShardResponse>(request, shardResponse, translogLocation, null, indexShard);
    }

    @Override
    protected TransportWriteAction.WriteReplicaResult<ShardDeleteRequest> processRequestItemsOnReplica(IndexShard indexShard, ShardDeleteRequest request) throws IOException {
        Translog.Location translogLocation = null;
        for (ShardDeleteRequest.Item item : request.items()) {
            int location = item.location();
            if (request.skipFromLocation() == location) break;
            if (item.seqNo() == -2L) continue;
            Engine.DeleteResult deleteResult = indexShard.applyDeleteOperationOnReplica(item.seqNo(), item.primaryTerm(), item.version(), item.id());
            translogLocation = deleteResult.getTranslogLocation();
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("shardId={} REPLICA: successfully deleted id={}", (Object)request.shardId(), (Object)item.id());
        }
        return new TransportWriteAction.WriteReplicaResult<ShardDeleteRequest>(request, translogLocation, null, indexShard, this.logger);
    }

    private Engine.DeleteResult shardDeleteOperationOnPrimary(ShardDeleteRequest.Item item, IndexShard indexShard) throws IOException {
        Engine.DeleteResult deleteResult = indexShard.applyDeleteOperationOnPrimary(item.version(), item.id(), VersionType.INTERNAL, item.seqNo(), item.primaryTerm());
        item.version(deleteResult.getVersion());
        item.seqNo(deleteResult.getSeqNo());
        item.primaryTerm(deleteResult.getTerm());
        return deleteResult;
    }
}

