/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.crate.common.CheckedSupplier;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.execution.ddl.SchemaUpdateClient;
import io.crate.execution.dml.ShardRequest;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.jobs.kill.KillAllListener;
import io.crate.execution.jobs.kill.KillableCallable;
import io.crate.metadata.ColumnIdent;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.MappingUpdatePerformer;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public abstract class TransportShardAction<Request extends ShardRequest<Request, Item>, Item extends ShardRequest.Item>
extends TransportWriteAction<Request, Request, ShardResponse>
implements KillAllListener {
    private final Multimap<UUID, KillableCallable> activeOperations = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final MappingUpdatePerformer mappingUpdate = (update, shardId) -> {
        TransportShardAction.validateMapping(update.root().iterator(), false);
        schemaUpdateClient.blockingUpdateOnMaster(shardId.getIndex(), update);
    };

    protected TransportShardAction(String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, Writeable.Reader<Request> reader, SchemaUpdateClient schemaUpdateClient) {
        super(actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, reader, reader, "write", false);
    }

    @Override
    protected ShardResponse newResponseInstance(StreamInput in) throws IOException {
        return new ShardResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(Request request, final IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<Request, ShardResponse>> listener) {
        ActionListener.completeWith(listener, () -> {
            KillableWrapper callable = new KillableWrapper<TransportWriteAction.WritePrimaryResult<Request, ShardResponse>>((ShardRequest)request){
                final /* synthetic */ ShardRequest val$request;
                {
                    this.val$request = shardRequest;
                }

                @Override
                public TransportWriteAction.WritePrimaryResult<Request, ShardResponse> call() throws Exception {
                    return TransportShardAction.this.processRequestItems(primary, this.val$request, this.killed);
                }
            };
            return (TransportReplicationAction.PrimaryResult)this.wrapOperationInKillable(request, callable);
        });
    }

    @Override
    protected TransportWriteAction.WriteReplicaResult<Request> shardOperationOnReplica(Request replicaRequest, final IndexShard indexShard) {
        KillableWrapper callable = new KillableWrapper<TransportWriteAction.WriteReplicaResult<Request>>((ShardRequest)replicaRequest){
            final /* synthetic */ ShardRequest val$replicaRequest;
            {
                this.val$replicaRequest = shardRequest;
            }

            @Override
            public TransportWriteAction.WriteReplicaResult<Request> call() throws Exception {
                return TransportShardAction.this.processRequestItemsOnReplica(indexShard, this.val$replicaRequest);
            }
        };
        return (TransportWriteAction.WriteReplicaResult)this.wrapOperationInKillable(replicaRequest, callable);
    }

    private <WrapperResponse> WrapperResponse wrapOperationInKillable(Request request, KillableCallable<WrapperResponse> callable) {
        Object response;
        this.activeOperations.put((Object)((ShardRequest)request).jobId(), callable);
        try {
            response = callable.call();
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.activeOperations.remove((Object)((ShardRequest)request).jobId(), callable);
        }
        return (WrapperResponse)response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killAllJobs() {
        Multimap<UUID, KillableCallable> multimap = this.activeOperations;
        synchronized (multimap) {
            for (KillableCallable callable : this.activeOperations.values()) {
                callable.kill(new InterruptedException("Job killed"));
            }
            this.activeOperations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killJob(UUID jobId) {
        Multimap<UUID, KillableCallable> multimap = this.activeOperations;
        synchronized (multimap) {
            Collection operations = this.activeOperations.get((Object)jobId);
            for (KillableCallable callable : operations) {
                callable.kill(new InterruptedException("Job killed"));
            }
            this.activeOperations.removeAll((Object)jobId);
        }
    }

    protected abstract TransportWriteAction.WritePrimaryResult<Request, ShardResponse> processRequestItems(IndexShard var1, Request var2, AtomicBoolean var3) throws InterruptedException, IOException;

    protected abstract TransportWriteAction.WriteReplicaResult<Request> processRequestItemsOnReplica(IndexShard var1, Request var2) throws IOException;

    protected <T extends Engine.Result> T executeOnPrimaryHandlingMappingUpdate(ShardId shardId, CheckedSupplier<T, IOException> execute, Function<Exception, T> onMappingUpdateError) throws IOException {
        Engine.Result result = (Engine.Result)execute.get();
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            try {
                this.mappingUpdate.updateMappings(result.getRequiredMappingUpdate(), shardId);
            }
            catch (Exception e) {
                return (T)((Engine.Result)onMappingUpdateError.apply(e));
            }
            result = (Engine.Result)execute.get();
            if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new ReplicationOperation.RetryOnPrimaryException(shardId, "Dynamic mappings are not available on the node that holds the primary yet");
            }
        }
        assert (!(result.getFailure() instanceof ReplicationOperation.RetryOnPrimaryException)) : "IndexShard shouldn't use RetryOnPrimaryException. got " + result.getFailure();
        return (T)result;
    }

    @VisibleForTesting
    public static void validateMapping(Iterator<Mapper> mappers, boolean nested) {
        while (mappers.hasNext()) {
            Mapper mapper = mappers.next();
            if (nested) {
                ColumnIdent.validateObjectKey(mapper.simpleName());
            } else {
                ColumnIdent.validateColumnName(mapper.simpleName());
            }
            TransportShardAction.validateMapping(mapper.iterator(), true);
        }
    }

    static abstract class KillableWrapper<WrapperResponse>
    implements KillableCallable<WrapperResponse> {
        protected AtomicBoolean killed = new AtomicBoolean(false);

        KillableWrapper() {
        }

        @Override
        public void kill(@Nullable Throwable t) {
            this.killed.getAndSet(true);
        }
    }
}

