/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.CollectionBucket;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.expression.reference.sys.SysRowUpdater;
import io.crate.expression.reference.sys.check.node.SysNodeCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collector;

public class SysUpdateResultSetProjector
implements Projector {
    private final Consumer<Object> rowWriter;
    private final List<NestableCollectExpression<SysNodeCheck, ?>> expressions;
    private final List<Input<?>> inputs;
    private final SysRowUpdater<?> sysRowUpdater;

    public SysUpdateResultSetProjector(SysRowUpdater<?> sysRowUpdater, Consumer<Object> rowWriter, List<NestableCollectExpression<SysNodeCheck, ?>> expressions, List<Input<?>> inputs) {
        this.sysRowUpdater = sysRowUpdater;
        this.rowWriter = rowWriter;
        this.expressions = expressions;
        this.inputs = inputs;
    }

    @Override
    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        return CollectingBatchIterator.newInstance(batchIterator, Collector.of(ArrayList::new, (acc, row) -> {
            Object[] returnValues = this.evaluateReturnValues((Row)row);
            acc.add(returnValues);
        }, (state1, state2) -> {
            throw new UnsupportedOperationException("Combine not supported");
        }, CollectionBucket::new, new Collector.Characteristics[0]));
    }

    private Object[] evaluateReturnValues(Row row) {
        Object sysNodeCheckId = row.get(0);
        this.rowWriter.accept(sysNodeCheckId);
        SysNodeCheck sysNodeCheck = (SysNodeCheck)this.sysRowUpdater.getRow(sysNodeCheckId);
        this.expressions.forEach(x -> x.setNextRow(sysNodeCheck));
        Object[] result = new Object[this.inputs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.inputs.get(i).value();
        }
        return result;
    }

    @Override
    public boolean providesIndependentScroll() {
        return true;
    }
}

