/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.Streamer;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.WriteResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class ShardResponse
extends ReplicationResponse
implements WriteResponse {
    private IntArrayList locations = new IntArrayList();
    private List<Failure> failures = new ArrayList<Failure>();
    @Nullable
    private List<Object[]> resultRows;
    @Nullable
    private Symbol[] resultColumns;
    @Nullable
    private Exception failure;

    public ShardResponse() {
    }

    public ShardResponse(@Nullable Symbol[] resultColumns) {
        this.resultColumns = resultColumns;
    }

    public void add(int location) {
        this.locations.add(location);
        this.failures.add(null);
    }

    public void add(int location, Failure failure) {
        this.locations.add(location);
        this.failures.add(failure);
    }

    public void addResultRows(Object[] rows) {
        if (this.resultRows == null) {
            this.resultRows = new ArrayList<Object[]>();
        }
        this.resultRows.add(rows);
    }

    @Nullable
    public List<Object[]> getResultRows() {
        return this.resultRows;
    }

    public IntArrayList itemIndices() {
        return this.locations;
    }

    public List<Failure> failures() {
        return this.failures;
    }

    public void failure(@Nullable Exception failure) {
        this.failure = failure;
    }

    public Exception failure() {
        return this.failure;
    }

    public ShardResponse(StreamInput in) throws IOException {
        super(in);
        int resultColumnsSize;
        int size = in.readVInt();
        this.locations = new IntArrayList(size);
        this.failures = new ArrayList<Failure>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                this.failures.add(new Failure(in));
                continue;
            }
            this.failures.add(null);
        }
        if (in.readBoolean()) {
            this.failure = in.readException();
        }
        if (in.getVersion().onOrAfter(Version.V_4_2_0) && (resultColumnsSize = in.readVInt()) > 0) {
            this.resultColumns = new Symbol[resultColumnsSize];
            for (int i = 0; i < resultColumnsSize; ++i) {
                Symbol symbol;
                this.resultColumns[i] = symbol = Symbols.fromStream(in);
            }
            Streamer<?>[] resultRowStreamers = Symbols.streamerArray(List.of(this.resultColumns));
            int resultRowsSize = in.readVInt();
            if (resultRowsSize > 0) {
                this.resultRows = new ArrayList<Object[]>(resultRowsSize);
                int rowLength = in.readVInt();
                for (int i = 0; i < resultRowsSize; ++i) {
                    Object[] row = new Object[rowLength];
                    for (int j = 0; j < rowLength; ++j) {
                        row[j] = resultRowStreamers[j].readValueFrom(in);
                    }
                    this.resultRows.add(row);
                }
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.failures.get(i) == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            this.failures.get(i).writeTo(out);
        }
        if (this.failure != null) {
            out.writeBoolean(true);
            out.writeException(this.failure);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            if (this.resultRows != null) {
                assert (this.resultColumns != null) : "Result columns are required when writing result rows";
                Streamer<?>[] resultRowStreamers = Symbols.streamerArray(List.of(this.resultColumns));
                out.writeVInt(this.resultColumns.length);
                for (int i = 0; i < this.resultColumns.length; ++i) {
                    Symbols.toStream(this.resultColumns[i], out);
                }
                out.writeVInt(this.resultRows.size());
                int rowLength = this.resultRows.get(0).length;
                out.writeVInt(rowLength);
                for (Object[] row : this.resultRows) {
                    for (int j = 0; j < rowLength; ++j) {
                        resultRowStreamers[j].writeValueTo(out, row[j]);
                    }
                }
            } else {
                out.writeVInt(0);
            }
        }
    }

    public int successRowCount() {
        int numSuccessful = 0;
        for (int i = 0; i < this.locations.size(); ++i) {
            Failure failure = this.failures.get(i);
            if (failure != null) continue;
            ++numSuccessful;
        }
        return numSuccessful;
    }

    public static class Failure
    implements Writeable {
        private final String id;
        private final String message;
        private final boolean versionConflict;

        public Failure(String id, String message, boolean versionConflict) {
            this.id = id;
            this.message = message;
            this.versionConflict = versionConflict;
        }

        public Failure(StreamInput in) throws IOException {
            this.id = in.readString();
            this.message = in.readString();
            this.versionConflict = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            out.writeString(this.message);
            out.writeBoolean(this.versionConflict);
        }

        public String id() {
            return this.id;
        }

        public String message() {
            return this.message;
        }

        public boolean versionConflict() {
            return this.versionConflict;
        }

        public String toString() {
            return "Failure{id='" + this.id + "', message='" + this.message + "', versionConflict=" + this.versionConflict + "}";
        }
    }

    public static class CompressedResult {
        private final BitSet successfulWrites = new BitSet();
        private final BitSet failureLocations = new BitSet();
        private final ArrayList<Object[]> resultRows = new ArrayList();

        public void update(ShardResponse response) {
            IntArrayList itemIndices = response.itemIndices();
            List<Failure> failures = response.failures();
            for (int i = 0; i < itemIndices.size(); ++i) {
                int location = itemIndices.get(i);
                Failure failure = failures.get(i);
                if (failure == null) {
                    this.successfulWrites.set(location, true);
                    continue;
                }
                this.failureLocations.set(location, true);
            }
            List<Object[]> resultRows = response.getResultRows();
            if (resultRows != null) {
                this.resultRows.addAll(resultRows);
            }
        }

        public boolean successfulWrites(int location) {
            return this.successfulWrites.get(location);
        }

        public boolean failed(int location) {
            return this.failureLocations.get(location);
        }

        public List<Object[]> resultRows() {
            return this.resultRows;
        }

        public int numSuccessfulWrites() {
            return this.successfulWrites.cardinality();
        }

        public void markAsFailed(List<ShardUpsertRequest.Item> items) {
            for (ShardUpsertRequest.Item item : items) {
                this.failureLocations.set(item.location());
            }
        }
    }
}

