/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntCollection;
import io.crate.analyze.where.DocKeys;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.RowN;
import io.crate.data.SentinelRow;
import io.crate.exceptions.Exceptions;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.dml.BulkShardResponseListener;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.support.MultiActionListener;
import io.crate.execution.support.OneRowActionListener;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.operators.SubQueryResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.ShardId;

public class ShardRequestExecutor<Req> {
    private final ClusterService clusterService;
    private final TransactionContext txnCtx;
    private final NodeContext nodeCtx;
    private final DocTableInfo table;
    private final RequestGrouper<Req> grouper;
    private final BiConsumer<Req, ActionListener<ShardResponse>> transportAction;
    private final DocKeys docKeys;

    public ShardRequestExecutor(ClusterService clusterService, TransactionContext txnCtx, NodeContext nodeCtx, DocTableInfo table, RequestGrouper<Req> grouper, BiConsumer<Req, ActionListener<ShardResponse>> transportAction, DocKeys docKeys) {
        this.clusterService = clusterService;
        this.txnCtx = txnCtx;
        this.nodeCtx = nodeCtx;
        this.table = table;
        this.grouper = grouper;
        this.transportAction = transportAction;
        this.docKeys = docKeys;
    }

    public void execute(RowConsumer consumer, Row parameters, SubQueryResults subQueryResults) {
        this.execute(consumer, parameters, subQueryResults, this::rowCountListener);
    }

    public void executeCollectValues(RowConsumer consumer, Row parameters, SubQueryResults subQueryResults) {
        this.execute(consumer, parameters, subQueryResults, this::resultSetListener);
    }

    private void execute(RowConsumer consumer, Row parameters, SubQueryResults subQueryResults, BiFunction<RowConsumer, Integer, ActionListener<ShardResponse>> f) {
        HashMap requestsByShard = new HashMap();
        this.grouper.bind(parameters, subQueryResults);
        this.addRequests(0, parameters, requestsByShard, subQueryResults);
        ActionListener<ShardResponse> listener = f.apply(consumer, requestsByShard.size());
        for (Object request : requestsByShard.values()) {
            this.transportAction.accept(request, listener);
        }
    }

    public List<CompletableFuture<Long>> executeBulk(List<Row> bulkParams, SubQueryResults subQueryResults) {
        HashMap requests = new HashMap();
        IntArrayList bulkIndices = new IntArrayList(bulkParams.size() * this.docKeys.size());
        int location = 0;
        for (int resultIdx = 0; resultIdx < bulkParams.size(); ++resultIdx) {
            int prevLocation = location;
            Row params = bulkParams.get(resultIdx);
            this.grouper.bind(params, subQueryResults);
            location = this.addRequests(location, params, requests, subQueryResults);
            for (int i = prevLocation; i < location; ++i) {
                bulkIndices.add(resultIdx);
            }
        }
        BulkShardResponseListener listener = new BulkShardResponseListener(requests.size(), bulkParams.size(), (IntCollection)bulkIndices);
        for (Object req : requests.values()) {
            this.transportAction.accept(req, listener);
        }
        return listener.rowCountFutures();
    }

    private int addRequests(int location, Row parameters, Map<ShardId, Req> requests, SubQueryResults subQueryResults) {
        for (DocKeys.DocKey docKey : this.docKeys) {
            ShardId shardId;
            String id = docKey.getId(this.txnCtx, this.nodeCtx, parameters, subQueryResults);
            if (id == null) continue;
            String routing = docKey.getRouting(this.txnCtx, this.nodeCtx, parameters, subQueryResults);
            List<String> partitionValues = docKey.getPartitionValues(this.txnCtx, this.nodeCtx, parameters, subQueryResults);
            String indexName = partitionValues == null ? this.table.ident().indexNameOrAlias() : IndexParts.toIndexName(this.table.ident(), PartitionName.encodeIdent(partitionValues));
            try {
                shardId = ShardRequestExecutor.getShardId(this.clusterService, indexName, id, routing);
            }
            catch (IndexNotFoundException e) {
                if (this.table.isPartitioned()) continue;
                throw e;
            }
            Req request = requests.get(shardId);
            if (request == null) {
                request = this.grouper.newRequest(shardId);
                requests.put(shardId, request);
            }
            Long version = docKey.version(this.txnCtx, this.nodeCtx, parameters, subQueryResults).orElse(null);
            Long seqNo = docKey.sequenceNo(this.txnCtx, this.nodeCtx, parameters, subQueryResults).orElse(null);
            Long primaryTerm = docKey.primaryTerm(this.txnCtx, this.nodeCtx, parameters, subQueryResults).orElse(null);
            this.grouper.addItem(request, location, id, version, seqNo, primaryTerm);
            ++location;
        }
        return location;
    }

    private static ShardId getShardId(ClusterService clusterService, String index, String id, String routing) {
        return clusterService.operationRouting().indexShards(clusterService.state(), index, id, routing).shardId();
    }

    private ActionListener<ShardResponse> rowCountListener(RowConsumer consumer, int numberResponse) {
        return new MultiActionListener<ShardResponse, long[], Row1>(numberResponse, () -> new long[]{0L}, this::countRows, rowCount -> new Row1(rowCount[0]), new OneRowActionListener(consumer, Function.identity()));
    }

    private ActionListener<ShardResponse> resultSetListener(final RowConsumer consumer, int numberResponse) {
        return new MultiActionListener<ShardResponse, ArrayList, List<Row>>(numberResponse, ArrayList::new, this::collectResults, Function.identity(), new ActionListener<List<Row>>(){

            @Override
            public void onResponse(List<Row> rows) {
                consumer.accept(InMemoryBatchIterator.of(rows, SentinelRow.SENTINEL, false), null);
            }

            @Override
            public void onFailure(Exception e) {
                consumer.accept(null, e);
            }
        });
    }

    private void countRows(long[] rowCount, ShardResponse response) {
        ShardRequestExecutor.updateOrFail(rowCount, response, (acc, b) -> {
            acc[0] = acc[0] + 1L;
        });
    }

    private void collectResults(List<Row> values, ShardResponse response) {
        ShardRequestExecutor.updateOrFail(values, response, (acc, res) -> {
            List<Object[]> resultRows = res.getResultRows();
            if (resultRows != null) {
                resultRows.forEach(x -> acc.add(new RowN(x)));
            }
        });
    }

    private static <A> void updateOrFail(A acc, ShardResponse response, BiConsumer<A, ShardResponse> f) {
        Throwable t;
        Exception exception = response.failure();
        if (exception != null && !((t = SQLExceptions.unwrap(exception, e -> e instanceof RuntimeException)) instanceof DocumentMissingException) && !(t instanceof VersionConflictEngineException)) {
            throw Exceptions.toRuntimeException(t);
        }
        for (int i = 0; i < response.itemIndices().size(); ++i) {
            ShardResponse.Failure failure = response.failures().get(i);
            if (failure == null) {
                f.accept(acc, response);
                continue;
            }
            if (failure.versionConflict() || failure.message().contains("Document not found") || failure.message().contains("document missing")) continue;
            throw new RuntimeException(failure.message());
        }
    }

    public static interface RequestGrouper<R> {
        public R newRequest(ShardId var1);

        public void bind(Row var1, SubQueryResults var2);

        public void addItem(R var1, int var2, String var3, @Nullable Long var4, @Nullable Long var5, @Nullable Long var6);
    }
}

