/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.support.MultiActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.VersionConflictEngineException;

final class BulkShardResponseListener
implements ActionListener<ShardResponse> {
    private final ShardResponse.CompressedResult compressedResult;
    private final ArrayList<CompletableFuture<Long>> results = new ArrayList();
    private final MultiActionListener<ShardResponse, ?, long[]> listener;

    BulkShardResponseListener(int numCallbacks, int numBulkParams, IntCollection resultIndices) {
        for (int i = 0; i < numBulkParams; ++i) {
            this.results.add(new CompletableFuture());
        }
        this.compressedResult = new ShardResponse.CompressedResult();
        this.listener = new MultiActionListener<ShardResponse, ShardResponse.CompressedResult, long[]>(numCallbacks, () -> this.compressedResult, BulkShardResponseListener::onResponse, responses -> BulkShardResponseListener.toRowCounts(responses, resultIndices, numBulkParams), new SetResultFutures(this.results));
    }

    private static void onResponse(ShardResponse.CompressedResult result, ShardResponse response) {
        Exception failure = response.failure();
        if (failure == null) {
            result.update(response);
        } else {
            Throwable t = SQLExceptions.unwrap(failure, e -> e instanceof RuntimeException);
            if (!(t instanceof DocumentMissingException) && !(t instanceof VersionConflictEngineException)) {
                throw new RuntimeException(t);
            }
        }
    }

    public List<CompletableFuture<Long>> rowCountFutures() {
        return this.results;
    }

    @Override
    public void onResponse(ShardResponse shardResponse) {
        this.listener.onResponse(shardResponse);
    }

    @Override
    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }

    private static long[] toRowCounts(ShardResponse.CompressedResult result, IntCollection items, int numBulkParams) {
        long[] rowCounts = new long[numBulkParams];
        Arrays.fill(rowCounts, 0L);
        for (IntCursor c : items) {
            int itemLocation = c.index;
            int resultIdx = c.value;
            if (result.successfulWrites(itemLocation)) {
                int n = resultIdx;
                rowCounts[n] = rowCounts[n] + 1L;
                continue;
            }
            if (!result.failed(itemLocation)) continue;
            rowCounts[resultIdx] = -2L;
        }
        return rowCounts;
    }

    private static class SetResultFutures
    implements ActionListener<long[]> {
        private final ArrayList<CompletableFuture<Long>> results;

        SetResultFutures(ArrayList<CompletableFuture<Long>> results) {
            this.results = results;
        }

        @Override
        public void onResponse(long[] rowCounts) {
            for (int i = 0; i < rowCounts.length; ++i) {
                this.results.get(i).complete(rowCounts[i]);
            }
        }

        @Override
        public void onFailure(Exception e) {
            for (CompletableFuture<Long> result : this.results) {
                result.completeExceptionally(e);
            }
        }
    }
}

