/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.views;

import io.crate.execution.ddl.views.CreateViewRequest;
import io.crate.execution.ddl.views.CreateViewResponse;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.view.ViewsMetadata;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class TransportCreateViewAction
extends TransportMasterNodeAction<CreateViewRequest, CreateViewResponse> {
    @Inject
    public TransportCreateViewAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("internal:crate:sql/views/create", transportService, clusterService, threadPool, CreateViewRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected CreateViewResponse read(StreamInput in) throws IOException {
        return new CreateViewResponse(in);
    }

    @Override
    protected void masterOperation(Task task, final CreateViewRequest request, ClusterState state, ActionListener<CreateViewResponse> listener) {
        ViewsMetadata views = (ViewsMetadata)state.metadata().custom("views");
        if (TransportCreateViewAction.conflictsWithTable(request.name(), state.metadata()) || TransportCreateViewAction.conflictsWithView(request, views)) {
            listener.onResponse(new CreateViewResponse(true));
        } else {
            this.clusterService.submitStateUpdateTask("views/create [" + request.name() + "]", new AckedClusterStateUpdateTask<CreateViewResponse>(Priority.HIGH, (AckedRequest)request, listener){
                boolean alreadyExitsFailure;
                {
                    super(priority, request2, listener);
                    this.alreadyExitsFailure = false;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ViewsMetadata views = (ViewsMetadata)currentState.metadata().custom("views");
                    if (TransportCreateViewAction.conflictsWithTable(request.name(), currentState.metadata()) || TransportCreateViewAction.conflictsWithView(request, views)) {
                        this.alreadyExitsFailure = true;
                        return currentState;
                    }
                    return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("views", ViewsMetadata.addOrReplace(views, request.name(), request.query(), request.owner())).build()).build();
                }

                @Override
                protected CreateViewResponse newResponse(boolean acknowledged) {
                    return new CreateViewResponse(this.alreadyExitsFailure);
                }
            });
        }
    }

    private static boolean conflictsWithTable(RelationName viewName, Metadata indexMetadata) {
        return indexMetadata.hasIndex(viewName.indexNameOrAlias()) || indexMetadata.templates().containsKey(PartitionName.templateName(viewName.schema(), viewName.name()));
    }

    private static boolean conflictsWithView(CreateViewRequest request, ViewsMetadata views) {
        return !request.replaceExisting() && views != null && views.contains(request.name());
    }

    @Override
    protected ClusterBlockException checkBlock(CreateViewRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

