/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.views;

import io.crate.common.unit.TimeValue;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DropViewRequest
extends MasterNodeRequest<DropViewRequest>
implements AckedRequest {
    private final List<RelationName> names;
    private final boolean ifExists;

    public DropViewRequest(List<RelationName> names, boolean ifExists) {
        this.names = names;
        this.ifExists = ifExists;
    }

    @Override
    public TimeValue ackTimeout() {
        return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
    }

    public List<RelationName> names() {
        return this.names;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public DropViewRequest(StreamInput in) throws IOException {
        super(in);
        this.names = in.readList(RelationName::new);
        this.ifExists = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.names);
        out.writeBoolean(this.ifExists);
    }
}

