/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.views;

import io.crate.common.unit.TimeValue;
import io.crate.metadata.RelationName;
import java.io.IOException;
import javax.annotation.Nullable;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class CreateViewRequest
extends MasterNodeRequest<CreateViewRequest>
implements AckedRequest {
    private final RelationName name;
    private final String query;
    private final boolean replaceExisting;
    @Nullable
    private final String owner;

    public CreateViewRequest(RelationName name, String query, boolean replaceExisting, @Nullable String owner) {
        this.name = name;
        this.query = query;
        this.replaceExisting = replaceExisting;
        this.owner = owner;
    }

    public RelationName name() {
        return this.name;
    }

    public String query() {
        return this.query;
    }

    boolean replaceExisting() {
        return this.replaceExisting;
    }

    @Nullable
    String owner() {
        return this.owner;
    }

    @Override
    public TimeValue ackTimeout() {
        return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
    }

    public CreateViewRequest(StreamInput in) throws IOException {
        super(in);
        this.name = new RelationName(in);
        this.query = in.readString();
        this.replaceExisting = in.readBoolean();
        this.owner = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.name.writeTo(out);
        out.writeString(this.query);
        out.writeBoolean(this.replaceExisting);
        out.writeOptionalString(this.owner);
    }
}

