/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.tables.RenameTableRequest;
import io.crate.execution.support.ActionListeners;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.RenameTableClusterStateExecutor;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportRenameTableAction
extends TransportMasterNodeAction<RenameTableRequest, AcknowledgedResponse> {
    private static final String ACTION_NAME = "internal:crate:sql/table/rename";
    private static final IndicesOptions STRICT_INDICES_OPTIONS = IndicesOptions.fromOptions(false, false, false, false);
    private final RenameTableClusterStateExecutor executor;
    private final ActiveShardsObserver activeShardsObserver;

    @Inject
    public TransportRenameTableAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, DDLClusterStateService ddlClusterStateService) {
        super(ACTION_NAME, transportService, clusterService, threadPool, RenameTableRequest::new, indexNameExpressionResolver);
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.executor = new RenameTableClusterStateExecutor(indexNameExpressionResolver, allocationService, ddlClusterStateService);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(Task task, final RenameTableRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        final AtomicReference<Object> newIndexNames = new AtomicReference<Object>(null);
        ActionListener<AcknowledgedResponse> waitForShardsListener = ActionListeners.waitForShards(listener, this.activeShardsObserver, request.timeout(), () -> this.logger.info("Renamed a relation, but the operation timed out waiting for enough shards to become available"), newIndexNames::get);
        this.clusterService.submitStateUpdateTask("rename-table", new AckedClusterStateUpdateTask<AcknowledgedResponse>(Priority.HIGH, (AckedRequest)request, waitForShardsListener){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ClusterState updatedState = TransportRenameTableAction.this.executor.execute(currentState, request);
                IndicesOptions openIndices = IndicesOptions.fromOptions(true, true, true, false, true, true, false);
                newIndexNames.set(TransportRenameTableAction.this.indexNameExpressionResolver.concreteIndexNames(updatedState, openIndices, request.targetTableIdent().indexNameOrAlias()));
                return updatedState;
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }
        });
    }

    @Override
    protected ClusterBlockException checkBlock(RenameTableRequest request, ClusterState state) {
        try {
            return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, STRICT_INDICES_OPTIONS, request.sourceTableIdent().indexNameOrAlias()));
        }
        catch (IndexNotFoundException e) {
            if (!request.isPartitioned()) {
                throw e;
            }
            return null;
        }
    }
}

