/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.OpenCloseTableOrPartitionRequest;
import io.crate.metadata.cluster.CloseTableClusterStateTaskExecutor;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.OpenTableClusterStateTaskExecutor;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataIndexUpgradeService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportOpenCloseTableOrPartitionAction
extends AbstractDDLTransportAction<OpenCloseTableOrPartitionRequest, AcknowledgedResponse> {
    private static final IndicesOptions STRICT_INDICES_OPTIONS = IndicesOptions.fromOptions(false, false, false, false);
    private static final String ACTION_NAME = "internal:crate:sql/table_or_partition/open_close";
    private final OpenTableClusterStateTaskExecutor openExecutor;
    private final CloseTableClusterStateTaskExecutor closeExecutor;

    @Inject
    public TransportOpenCloseTableOrPartitionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, DDLClusterStateService ddlClusterStateService, MetadataIndexUpgradeService metadataIndexUpgradeService, IndicesService indexServices) {
        super(ACTION_NAME, transportService, clusterService, threadPool, indexNameExpressionResolver, OpenCloseTableOrPartitionRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "open-table-or-partition");
        this.openExecutor = new OpenTableClusterStateTaskExecutor(indexNameExpressionResolver, allocationService, ddlClusterStateService, metadataIndexUpgradeService, indexServices);
        this.closeExecutor = new CloseTableClusterStateTaskExecutor(indexNameExpressionResolver, allocationService, ddlClusterStateService);
    }

    @Override
    public ClusterStateTaskExecutor<OpenCloseTableOrPartitionRequest> clusterStateTaskExecutor(OpenCloseTableOrPartitionRequest request) {
        if (request.isOpenTable()) {
            return this.openExecutor;
        }
        return this.closeExecutor;
    }

    @Override
    protected ClusterBlockException checkBlock(OpenCloseTableOrPartitionRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, STRICT_INDICES_OPTIONS, request.tableIdent().indexNameOrAlias()));
    }
}

