/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.DropTableRequest;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.cluster.DropTableClusterStateTaskExecutor;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportDropTableAction
extends AbstractDDLTransportAction<DropTableRequest, AcknowledgedResponse> {
    private static final String ACTION_NAME = "internal:crate:sql/table/drop";
    private static final IndicesOptions INDICES_OPTIONS = IndicesOptions.fromOptions(false, true, true, true);
    private final DropTableClusterStateTaskExecutor executor;

    @Inject
    public TransportDropTableAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, MetadataDeleteIndexService deleteIndexService, DDLClusterStateService ddlClusterStateService) {
        super(ACTION_NAME, transportService, clusterService, threadPool, indexNameExpressionResolver, DropTableRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "drop-table");
        this.executor = new DropTableClusterStateTaskExecutor(indexNameExpressionResolver, deleteIndexService, ddlClusterStateService);
    }

    @Override
    public ClusterStateTaskExecutor<DropTableRequest> clusterStateTaskExecutor(DropTableRequest request) {
        return this.executor;
    }

    @Override
    protected ClusterBlockException checkBlock(DropTableRequest request, ClusterState state) {
        IndicesOptions indicesOptions = INDICES_OPTIONS;
        if (request.isPartitioned()) {
            indicesOptions = IndicesOptions.lenientExpandOpen();
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, request.tableIdent().indexNameOrAlias()));
    }
}

