/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.exceptions.RelationAlreadyExists;
import io.crate.execution.ddl.tables.CreateTableRequest;
import io.crate.execution.ddl.tables.CreateTableResponse;
import io.crate.metadata.RelationName;
import io.crate.metadata.view.ViewsMetadata;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.TransportPutIndexTemplateAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateTableAction
extends TransportMasterNodeAction<CreateTableRequest, CreateTableResponse> {
    public static final String NAME = "internal:crate:sql/tables/admin/create";
    private final TransportCreateIndexAction transportCreateIndexAction;
    private final TransportPutIndexTemplateAction transportPutIndexTemplateAction;

    @Inject
    public TransportCreateTableAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, TransportCreateIndexAction transportCreateIndexAction, TransportPutIndexTemplateAction transportPutIndexTemplateAction) {
        super(NAME, transportService, clusterService, threadPool, CreateTableRequest::new, indexNameExpressionResolver);
        this.transportCreateIndexAction = transportCreateIndexAction;
        this.transportPutIndexTemplateAction = transportPutIndexTemplateAction;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected CreateTableResponse read(StreamInput in) throws IOException {
        return new CreateTableResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(CreateTableRequest request, ClusterState state) {
        if (request.getCreateIndexRequest() != null) {
            CreateIndexRequest createIndexRequest = request.getCreateIndexRequest();
            return this.transportCreateIndexAction.checkBlock(createIndexRequest, state);
        }
        if (request.getPutIndexTemplateRequest() != null) {
            PutIndexTemplateRequest putIndexTemplateRequest = request.getPutIndexTemplateRequest();
            return this.transportPutIndexTemplateAction.checkBlock(putIndexTemplateRequest, state);
        }
        throw new IllegalStateException("Unknown table request");
    }

    @Override
    protected void masterOperation(Task task, CreateTableRequest request, ClusterState state, ActionListener<CreateTableResponse> listener) {
        RelationName relationName = request.getTableName();
        if (TransportCreateTableAction.viewsExists(relationName, state)) {
            listener.onFailure(new RelationAlreadyExists(relationName));
            return;
        }
        if (request.getCreateIndexRequest() != null) {
            CreateIndexRequest createIndexRequest = request.getCreateIndexRequest();
            ActionListener<CreateIndexResponse> wrappedListener = ActionListener.wrap(response -> listener.onResponse(new CreateTableResponse(response.isShardsAcknowledged())), listener::onFailure);
            this.transportCreateIndexAction.masterOperation(task, createIndexRequest, state, wrappedListener);
        } else if (request.getPutIndexTemplateRequest() != null) {
            PutIndexTemplateRequest putIndexTemplateRequest = request.getPutIndexTemplateRequest();
            ActionListener<AcknowledgedResponse> wrappedListener = ActionListener.wrap(response -> listener.onResponse(new CreateTableResponse(response.isAcknowledged())), listener::onFailure);
            this.transportPutIndexTemplateAction.masterOperation(task, putIndexTemplateRequest, state, wrappedListener);
        } else {
            throw new IllegalStateException("Unknown table request");
        }
    }

    private static boolean viewsExists(RelationName relationName, ClusterState state) {
        ViewsMetadata views = (ViewsMetadata)state.metadata().custom("views");
        return views != null && views.contains(relationName);
    }
}

