/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.execution.ddl.tables.AlterTableTarget;
import io.crate.execution.ddl.tables.CloseTableRequest;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateHelpers;
import io.crate.metadata.cluster.DDLClusterStateService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.NotifyOnceListener;
import org.elasticsearch.action.admin.indices.close.TransportVerifyShardBeforeCloseAction;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class TransportCloseTable
extends TransportMasterNodeAction<CloseTableRequest, AcknowledgedResponse> {
    private static final Logger LOGGER = LogManager.getLogger(TransportCloseTable.class);
    private static final String ACTION_NAME = "internal:crate:sql/table_or_partition/close";
    private static final IndicesOptions STRICT_INDICES_OPTIONS = IndicesOptions.fromOptions(false, false, false, false);
    public static final int INDEX_CLOSED_BLOCK_ID = 4;
    private final TransportVerifyShardBeforeCloseAction verifyShardBeforeClose;
    private final AllocationService allocationService;
    private final DDLClusterStateService ddlClusterStateService;
    private final ActiveShardsObserver activeShardsObserver;

    @Inject
    public TransportCloseTable(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, DDLClusterStateService ddlClusterStateService, TransportVerifyShardBeforeCloseAction verifyShardBeforeClose) {
        super(ACTION_NAME, transportService, clusterService, threadPool, CloseTableRequest::new, indexNameExpressionResolver);
        this.allocationService = allocationService;
        this.ddlClusterStateService = ddlClusterStateService;
        this.verifyShardBeforeClose = verifyShardBeforeClose;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(Task task, CloseTableRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        assert (state.nodes().getMinNodeVersion().onOrAfter(Version.V_4_3_0)) : "All nodes must be on 4.3 to use the new dedicated close action";
        this.clusterService.submitStateUpdateTask("add-block-close-table", new AddCloseBlocksTask(listener, request));
    }

    static ClusterState closeRoutingTable(ClusterState currentState, AlterTableTarget target, DDLClusterStateService ddlClusterStateService, Map<Index, ClusterBlock> blockedIndices, Map<Index, AcknowledgedResponse> results) {
        ClusterState updatedState;
        boolean removeRoutingTable = currentState.nodes().getMinNodeVersion().before(Version.V_4_3_0);
        IndexTemplateMetadata templateMetadata = target.templateMetadata();
        if (templateMetadata == null) {
            updatedState = currentState;
        } else {
            Metadata.Builder metadata = Metadata.builder(currentState.metadata());
            metadata.put(TransportCloseTable.closePartitionTemplate(templateMetadata));
            updatedState = ClusterState.builder(currentState).metadata(metadata).build();
        }
        String partition = target.partition();
        if (partition != null) {
            PartitionName partitionName = PartitionName.fromIndexOrTemplate(partition);
            updatedState = ddlClusterStateService.onCloseTablePartition(updatedState, partitionName);
        } else {
            updatedState = ddlClusterStateService.onCloseTable(updatedState, target.table());
        }
        Metadata.Builder metadata = Metadata.builder(updatedState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(updatedState.blocks());
        RoutingTable.Builder routingTable = RoutingTable.builder(updatedState.routingTable());
        HashSet<String> closedIndices = new HashSet<String>();
        for (Map.Entry<Index, AcknowledgedResponse> result : results.entrySet()) {
            Index index = result.getKey();
            boolean acknowledged = result.getValue().isAcknowledged();
            try {
                if (!acknowledged) {
                    LOGGER.debug("verification of shards before closing {} failed", (Object)index);
                    continue;
                }
                IndexMetadata indexMetadata = metadata.getSafe(index);
                if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                    LOGGER.debug("verification of shards before closing {} succeeded but index is already closed", (Object)index);
                    assert (currentState.blocks().hasIndexBlock(index.getName(), IndexMetadata.INDEX_CLOSED_BLOCK));
                    continue;
                }
                ClusterBlock closingBlock = blockedIndices.get(index);
                if (!currentState.blocks().hasIndexBlock(index.getName(), closingBlock)) {
                    LOGGER.debug("verification of shards before closing {} succeeded but block has been removed in the meantime", (Object)index);
                    continue;
                }
                Set<Index> restoringIndices = RestoreService.restoringIndices(updatedState, Set.of(index));
                if (!restoringIndices.isEmpty()) {
                    result.setValue(new AcknowledgedResponse(false));
                    LOGGER.debug("verification of shards before closing {} succeeded but index is being restored in the meantime", (Object)index);
                    continue;
                }
                Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(updatedState, Set.of(index));
                if (!snapshottingIndices.isEmpty()) {
                    result.setValue(new AcknowledgedResponse(false));
                    LOGGER.debug("verification of shards before closing {} succeeded but index is being snapshot in the meantime", (Object)index);
                    continue;
                }
                blocks.removeIndexBlockWithId(index.getName(), 4);
                blocks.addIndexBlock(index.getName(), IndexMetadata.INDEX_CLOSED_BLOCK);
                IndexMetadata.Builder updatedMetadata = IndexMetadata.builder(indexMetadata).state(IndexMetadata.State.CLOSE);
                if (removeRoutingTable) {
                    metadata.put(updatedMetadata);
                    routingTable.remove(index.getName());
                } else {
                    metadata.put(updatedMetadata.settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(Settings.builder().put(indexMetadata.getSettings()).put(IndexMetadata.VERIFIED_BEFORE_CLOSE_SETTING.getKey(), true)));
                    routingTable.addAsFromOpenToClose(metadata.getSafe(index));
                }
                LOGGER.debug("closing index {} succeeded", (Object)index);
                closedIndices.add(index.getName());
            }
            catch (IndexNotFoundException e) {
                LOGGER.debug("index {} has been deleted since it was blocked before closing, ignoring", (Object)index);
            }
        }
        LOGGER.info("completed closing of indices {}", closedIndices);
        return ClusterState.builder(currentState).blocks(blocks).metadata(metadata).routingTable(routingTable.build()).build();
    }

    private static IndexTemplateMetadata closePartitionTemplate(IndexTemplateMetadata templateMetadata) {
        Map<String, Object> metaMap = Collections.singletonMap("_meta", Collections.singletonMap("closed", true));
        return DDLClusterStateHelpers.updateTemplate(templateMetadata, metaMap, Collections.emptyMap(), Settings.EMPTY, (n, s) -> {}, s -> true);
    }

    @Override
    protected ClusterBlockException checkBlock(CloseTableRequest request, ClusterState state) {
        String partition = request.partition();
        String indexName = partition == null ? request.table().indexNameOrAlias() : partition;
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, STRICT_INDICES_OPTIONS, indexName));
    }

    private static ClusterState addCloseBlocks(ClusterState currentState, Index[] indices, Map<Index, ClusterBlock> blockedIndices) {
        Metadata.Builder metadata = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        HashSet<Index> indicesToClose = new HashSet<Index>();
        for (Index index : indices) {
            IndexMetadata indexMetadata = metadata.getSafe(index);
            if (indexMetadata.getState() != IndexMetadata.State.CLOSE) {
                indicesToClose.add(index);
                continue;
            }
            LOGGER.debug("index {} is already closed, ignoring", (Object)index);
            assert (currentState.blocks().hasIndexBlock(index.getName(), IndexMetadata.INDEX_CLOSED_BLOCK));
        }
        if (indicesToClose.isEmpty()) {
            return currentState;
        }
        Set<Index> restoringIndices = RestoreService.restoringIndices(currentState, indicesToClose);
        if (!restoringIndices.isEmpty()) {
            throw new IllegalArgumentException("Cannot close indices that are being restored: " + restoringIndices);
        }
        Set<Index> snapshottingIndices = SnapshotsService.snapshottingIndices(currentState, indicesToClose);
        if (!snapshottingIndices.isEmpty()) {
            throw new SnapshotInProgressException("Cannot close indices that are being snapshotted: " + snapshottingIndices + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        for (Index index : indicesToClose) {
            ClusterBlock indexBlock = null;
            Set<ClusterBlock> clusterBlocks = currentState.blocks().indices().get(index.getName());
            if (clusterBlocks != null) {
                for (ClusterBlock clusterBlock : clusterBlocks) {
                    if (clusterBlock.id() != 4) continue;
                    indexBlock = clusterBlock;
                    break;
                }
            }
            if (indexBlock == null) {
                indexBlock = new ClusterBlock(4, UUIDs.randomBase64UUID(), "Table or partition preparing to close. Reopen the table to allow writes again or retry closing the table to fully close it.", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
            }
            assert (Strings.hasLength(indexBlock.uuid())) : "Closing block should have a UUID";
            blocks.addIndexBlock(index.getName(), indexBlock);
            blockedIndices.put(index, indexBlock);
        }
        return ClusterState.builder(currentState).blocks(blocks).metadata(metadata).routingTable(currentState.routingTable()).build();
    }

    private final class AddCloseBlocksTask
    extends ClusterStateUpdateTask {
        private final ActionListener<AcknowledgedResponse> listener;
        private final CloseTableRequest request;
        private final Map<Index, ClusterBlock> blockedIndices = new HashMap<Index, ClusterBlock>();

        private AddCloseBlocksTask(ActionListener<AcknowledgedResponse> listener, CloseTableRequest request) {
            this.listener = listener;
            this.request = request;
        }

        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            RelationName table = this.request.table();
            String partition = this.request.partition();
            Index[] indices = TransportCloseTable.this.indexNameExpressionResolver.concreteIndices(currentState, IndicesOptions.lenientExpandOpen(), partition == null ? table.indexNameOrAlias() : partition);
            if (indices.length == 0) {
                return currentState;
            }
            return TransportCloseTable.addCloseBlocks(currentState, indices, this.blockedIndices);
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.listener.onFailure(e);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            if (oldState == newState) {
                assert (this.blockedIndices.isEmpty()) : "List of blocked indices is not empty but cluster state wasn't changed";
                this.listener.onResponse(new AcknowledgedResponse(true));
                return;
            }
            assert (!this.blockedIndices.isEmpty()) : "List of blocked indices is empty but cluster state was changed";
            TransportCloseTable.this.threadPool.executor("management").execute(new WaitForClosedBlocksApplied(this.blockedIndices, ActionListener.wrap(results -> TransportCloseTable.this.clusterService.submitStateUpdateTask("close-indices", new CloseRoutingTableTask(Priority.URGENT, this.blockedIndices, (Map<Index, AcknowledgedResponse>)results, this.request, this.listener)), this.listener::onFailure)));
        }
    }

    class WaitForClosedBlocksApplied
    extends ActionRunnable<Map<Index, AcknowledgedResponse>> {
        private final Map<Index, ClusterBlock> blockedIndices;

        private WaitForClosedBlocksApplied(Map<Index, ClusterBlock> blockedIndices, ActionListener<Map<Index, AcknowledgedResponse>> listener) {
            super(listener);
            if (blockedIndices == null || blockedIndices.isEmpty()) {
                throw new IllegalArgumentException("Cannot wait for closed blocks to be applied, list of blocked indices is empty or null");
            }
            this.blockedIndices = blockedIndices;
        }

        @Override
        protected void doRun() throws Exception {
            ConcurrentMap results = ConcurrentCollections.newConcurrentMap();
            CountDown countDown = new CountDown(this.blockedIndices.size());
            ClusterState state = TransportCloseTable.this.clusterService.state();
            this.blockedIndices.forEach((index, block) -> this.waitForShardsReadyForClosing((Index)index, (ClusterBlock)block, state, response -> {
                results.put(index, response);
                if (countDown.countDown()) {
                    this.listener.onResponse(Collections.unmodifiableMap(results));
                }
            }));
        }

        private void waitForShardsReadyForClosing(Index index, ClusterBlock closingBlock, ClusterState state, final Consumer<AcknowledgedResponse> onResponse) {
            IndexMetadata indexMetadata = state.metadata().index(index);
            if (indexMetadata == null) {
                TransportCloseTable.this.logger.debug("index {} has been blocked before closing and is now deleted, ignoring", (Object)index);
                onResponse.accept(new AcknowledgedResponse(true));
                return;
            }
            IndexRoutingTable indexRoutingTable = state.routingTable().index(index);
            if (indexRoutingTable == null || indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                assert (state.blocks().hasIndexBlock(index.getName(), IndexMetadata.INDEX_CLOSED_BLOCK));
                TransportCloseTable.this.logger.debug("index {} has been blocked before closing and is already closed, ignoring", (Object)index);
                onResponse.accept(new AcknowledgedResponse(true));
                return;
            }
            ImmutableOpenIntMap<IndexShardRoutingTable> shards = indexRoutingTable.getShards();
            final AtomicArray results = new AtomicArray(shards.size());
            final CountDown countDown = new CountDown(shards.size());
            for (IntObjectCursor<IndexShardRoutingTable> intObjectCursor : shards) {
                IndexShardRoutingTable shardRoutingTable = (IndexShardRoutingTable)intObjectCursor.value;
                final ShardId shardId = shardRoutingTable.shardId();
                this.sendVerifyShardBeforeCloseRequest(shardRoutingTable, closingBlock, (ActionListener<ReplicationResponse>)new NotifyOnceListener<ReplicationResponse>(){

                    @Override
                    public void innerOnResponse(ReplicationResponse replicationResponse) {
                        ReplicationResponse.ShardInfo shardInfo = replicationResponse.getShardInfo();
                        results.setOnce(shardId.id(), new AcknowledgedResponse(shardInfo.getFailed() == 0));
                        this.processIfFinished();
                    }

                    @Override
                    public void innerOnFailure(Exception e) {
                        results.setOnce(shardId.id(), new AcknowledgedResponse(false));
                        this.processIfFinished();
                    }

                    private void processIfFinished() {
                        if (countDown.countDown()) {
                            boolean acknowledged = results.asList().stream().allMatch(AcknowledgedResponse::isAcknowledged);
                            onResponse.accept(new AcknowledgedResponse(acknowledged));
                        }
                    }
                });
            }
        }

        private void sendVerifyShardBeforeCloseRequest(IndexShardRoutingTable shardRoutingTable, final ClusterBlock closingBlock, final ActionListener<ReplicationResponse> listener) {
            final ShardId shardId = shardRoutingTable.shardId();
            if (shardRoutingTable.primaryShard().unassigned()) {
                TransportCloseTable.this.logger.debug("primary shard {} is unassigned, ignoring", (Object)shardId);
                ReplicationResponse response = new ReplicationResponse();
                response.setShardInfo(new ReplicationResponse.ShardInfo(shardRoutingTable.size(), shardRoutingTable.size(), new ReplicationResponse.ShardInfo.Failure[0]));
                listener.onResponse(response);
                return;
            }
            TransportVerifyShardBeforeCloseAction.ShardRequest shardRequest = new TransportVerifyShardBeforeCloseAction.ShardRequest(shardId, true, closingBlock);
            TransportCloseTable.this.verifyShardBeforeClose.execute(shardRequest, new ActionListener<ReplicationResponse>(){

                @Override
                public void onResponse(ReplicationResponse replicationResponse) {
                    TransportVerifyShardBeforeCloseAction.ShardRequest shardRequest = new TransportVerifyShardBeforeCloseAction.ShardRequest(shardId, false, closingBlock);
                    TransportCloseTable.this.verifyShardBeforeClose.execute(shardRequest, listener);
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    private final class CloseRoutingTableTask
    extends ClusterStateUpdateTask {
        private final Map<Index, AcknowledgedResponse> results;
        private final Map<Index, ClusterBlock> blockedIndices;
        private final ActionListener<AcknowledgedResponse> listener;
        private final CloseTableRequest request;
        boolean acknowledged;

        private CloseRoutingTableTask(Priority priority, Map<Index, ClusterBlock> blockedIndices, Map<Index, AcknowledgedResponse> results, CloseTableRequest request, ActionListener<AcknowledgedResponse> listener) {
            super(priority);
            this.acknowledged = true;
            this.blockedIndices = blockedIndices;
            this.results = results;
            this.listener = listener;
            this.request = request;
        }

        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            AlterTableTarget target = AlterTableTarget.resolve(TransportCloseTable.this.indexNameExpressionResolver, currentState, this.request.table(), this.request.partition());
            ClusterState updatedState = TransportCloseTable.closeRoutingTable(currentState, target, TransportCloseTable.this.ddlClusterStateService, this.blockedIndices, this.results);
            for (Map.Entry<Index, AcknowledgedResponse> result : this.results.entrySet()) {
                if (!result.getValue().isAcknowledged()) {
                    this.acknowledged = false;
                    break;
                }
                IndexMetadata updatedMetadata = updatedState.metadata().index(result.getKey());
                if (updatedMetadata == null || updatedMetadata.getState() == IndexMetadata.State.CLOSE) continue;
                this.acknowledged = false;
                break;
            }
            return TransportCloseTable.this.allocationService.reroute(updatedState, "indices closed");
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.listener.onFailure(e);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            String[] indices = (String[])this.results.entrySet().stream().filter(result -> ((AcknowledgedResponse)result.getValue()).isAcknowledged()).map(result -> ((Index)result.getKey()).getName()).filter(index -> newState.routingTable().hasIndex((String)index)).toArray(String[]::new);
            if (indices.length > 0) {
                TransportCloseTable.this.activeShardsObserver.waitForActiveShards(indices, ActiveShardCount.ONE, this.request.ackTimeout(), shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue() && LOGGER.isDebugEnabled()) {
                        LOGGER.debug("[{}] indices closed, but the operation timed out while waiting for enough shards to be started.", (Object)Arrays.toString(indices));
                    }
                    this.listener.onResponse(new AcknowledgedResponse(this.acknowledged));
                }, this.listener::onFailure);
            } else {
                this.listener.onResponse(new AcknowledgedResponse(this.acknowledged));
            }
        }
    }
}

