/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.analyze.BoundCreateTable;
import io.crate.exceptions.Exceptions;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.ddl.tables.CreateTableRequest;
import io.crate.execution.ddl.tables.TransportCreateTableAction;
import io.crate.execution.support.Transports;
import io.crate.metadata.RelationName;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;

@Singleton
public class TableCreator {
    protected static final Logger LOGGER = LogManager.getLogger(TableCreator.class);
    private final TransportCreateTableAction transportCreateTableAction;

    @Inject
    public TableCreator(TransportCreateTableAction transportCreateIndexAction) {
        this.transportCreateTableAction = transportCreateIndexAction;
    }

    public CompletableFuture<Long> create(BoundCreateTable createTable) {
        String templateName = createTable.templateName();
        RelationName relationName = createTable.tableIdent();
        CreateTableRequest createTableRequest = templateName == null ? new CreateTableRequest(new CreateIndexRequest(relationName.indexNameOrAlias(), createTable.tableParameter().settings()).mapping("default", createTable.mapping())) : new CreateTableRequest(new PutIndexTemplateRequest(templateName).mapping("default", createTable.mapping()).create(true).settings(createTable.tableParameter().settings()).patterns(Collections.singletonList(createTable.templatePrefix())).order(100).alias(new Alias(relationName.indexNameOrAlias())));
        return Transports.execute(this.transportCreateTableAction, createTableRequest, resp -> {
            if (!resp.isAllShardsAcked() && LOGGER.isWarnEnabled()) {
                LOGGER.warn("CREATE TABLE `{}` was not acknowledged. This could lead to inconsistent state.", (Object)relationName.fqn());
            }
            return 1L;
        }).exceptionally(error -> {
            Throwable t = SQLExceptions.unwrap(error);
            String message = t.getMessage();
            Throwable cause = t.getCause();
            if ("mapping [default]".equals(message) && cause != null) {
                return (Long)Exceptions.rethrowRuntimeException(cause);
            }
            if (createTable.ifNotExists() && TableCreator.isTableExistsError(t, templateName)) {
                return 0L;
            }
            return (Long)Exceptions.rethrowRuntimeException(t);
        });
    }

    private static boolean isTableExistsError(Throwable e, @Nullable String templateName) {
        return e instanceof ResourceAlreadyExistsException || templateName != null && TableCreator.isTemplateAlreadyExistsException(e);
    }

    private static boolean isTemplateAlreadyExistsException(Throwable e) {
        return e instanceof IllegalArgumentException && e.getMessage() != null && e.getMessage().endsWith("already exists");
    }
}

