/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.RelationName;
import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class RenameTableRequest
extends AcknowledgedRequest<RenameTableRequest> {
    private final RelationName sourceRelationName;
    private final RelationName targetRelationName;
    private final boolean isPartitioned;

    public RenameTableRequest(RelationName sourceRelationName, RelationName targetRelationName, boolean isPartitioned) {
        this.sourceRelationName = sourceRelationName;
        this.targetRelationName = targetRelationName;
        this.isPartitioned = isPartitioned;
    }

    public RelationName sourceTableIdent() {
        return this.sourceRelationName;
    }

    public RelationName targetTableIdent() {
        return this.targetRelationName;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public RenameTableRequest(StreamInput in) throws IOException {
        super(in);
        this.sourceRelationName = new RelationName(in);
        this.targetRelationName = new RelationName(in);
        this.isPartitioned = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.sourceRelationName.writeTo(out);
        this.targetRelationName.writeTo(out);
        out.writeBoolean(this.isPartitioned);
    }
}

