/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.RelationName;
import java.io.IOException;
import javax.annotation.Nullable;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OpenCloseTableOrPartitionRequest
extends AcknowledgedRequest<OpenCloseTableOrPartitionRequest> {
    private final RelationName relationName;
    @Nullable
    private final String partitionIndexName;
    private final boolean openTable;

    public OpenCloseTableOrPartitionRequest(RelationName relationName, @Nullable String partitionIndexName, boolean openTable) {
        this.relationName = relationName;
        this.partitionIndexName = partitionIndexName;
        this.openTable = openTable;
    }

    public RelationName tableIdent() {
        return this.relationName;
    }

    @Nullable
    public String partitionIndexName() {
        return this.partitionIndexName;
    }

    boolean isOpenTable() {
        return this.openTable;
    }

    public OpenCloseTableOrPartitionRequest(StreamInput in) throws IOException {
        super(in);
        this.relationName = new RelationName(in);
        this.partitionIndexName = in.readOptionalString();
        this.openTable = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.relationName.writeTo(out);
        out.writeOptionalString(this.partitionIndexName);
        out.writeBoolean(this.openTable);
    }
}

