/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.RelationName;
import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DropTableRequest
extends AcknowledgedRequest<DropTableRequest> {
    private final RelationName relationName;
    private final boolean isPartitioned;

    public DropTableRequest(RelationName relationName, boolean isPartitioned) {
        this.relationName = relationName;
        this.isPartitioned = isPartitioned;
    }

    public RelationName tableIdent() {
        return this.relationName;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public DropTableRequest(StreamInput in) throws IOException {
        super(in);
        this.relationName = new RelationName(in);
        this.isPartitioned = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.relationName.writeTo(out);
        out.writeBoolean(this.isPartitioned);
    }
}

