/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.common.unit.TimeValue;
import io.crate.metadata.RelationName;
import java.io.IOException;
import javax.annotation.Nullable;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class CreateTableRequest
extends MasterNodeRequest<CreateTableRequest>
implements AckedRequest {
    private final CreateIndexRequest createIndexRequest;
    private final PutIndexTemplateRequest putIndexTemplateRequest;

    public CreateTableRequest(CreateIndexRequest createIndexRequest) {
        this.createIndexRequest = createIndexRequest;
        this.putIndexTemplateRequest = null;
    }

    public CreateTableRequest(PutIndexTemplateRequest putIndexTemplateRequest) {
        this.createIndexRequest = null;
        this.putIndexTemplateRequest = putIndexTemplateRequest;
    }

    @Nullable
    public CreateIndexRequest getCreateIndexRequest() {
        return this.createIndexRequest;
    }

    @Nullable
    public PutIndexTemplateRequest getPutIndexTemplateRequest() {
        return this.putIndexTemplateRequest;
    }

    public RelationName getTableName() {
        if (this.createIndexRequest != null) {
            return RelationName.fromIndexName(this.createIndexRequest.index());
        }
        if (this.putIndexTemplateRequest != null) {
            return RelationName.fromIndexName(this.putIndexTemplateRequest.aliases().iterator().next().name());
        }
        throw new IllegalStateException("Unknown request type");
    }

    @Override
    public TimeValue ackTimeout() {
        return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
    }

    public CreateTableRequest(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.createIndexRequest = new CreateIndexRequest(in);
            this.putIndexTemplateRequest = null;
        } else {
            this.putIndexTemplateRequest = new PutIndexTemplateRequest(in);
            this.createIndexRequest = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        boolean isIndexRequest = this.createIndexRequest != null;
        out.writeBoolean(isIndexRequest);
        MasterNodeRequest request = isIndexRequest ? this.createIndexRequest : this.putIndexTemplateRequest;
        request.writeTo(out);
    }
}

