/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.RelationName;
import java.io.IOException;
import javax.annotation.Nullable;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class CloseTableRequest
extends AcknowledgedRequest<CloseTableRequest> {
    private final RelationName table;
    private final String partition;

    public CloseTableRequest(RelationName table, @Nullable String partition) {
        this.table = table;
        this.partition = partition;
    }

    public CloseTableRequest(StreamInput in) throws IOException {
        super(in);
        this.table = new RelationName(in);
        this.partition = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.table.writeTo(out);
        out.writeOptionalString(this.partition);
    }

    public RelationName table() {
        return this.table;
    }

    @Nullable
    public String partition() {
        return this.partition;
    }
}

