/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import javax.annotation.Nullable;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.index.Index;

public final class AlterTableTarget {
    private final Index[] indices;
    @Nullable
    private final IndexTemplateMetadata indexTemplateMetadata;
    private final RelationName table;
    private final String partition;

    public static AlterTableTarget resolve(IndexNameExpressionResolver indexNameResolver, ClusterState state, RelationName table, @Nullable String partition) {
        if (partition == null) {
            Index[] indices = indexNameResolver.concreteIndices(state, IndicesOptions.lenientExpandOpen(), table.indexNameOrAlias());
            String templateName = PartitionName.templateName(table.schema(), table.name());
            IndexTemplateMetadata indexTemplateMetadata = state.metadata().getTemplates().get(templateName);
            return new AlterTableTarget(table, partition, indices, indexTemplateMetadata);
        }
        Index[] indices = indexNameResolver.concreteIndices(state, IndicesOptions.lenientExpandOpen(), partition);
        return new AlterTableTarget(table, partition, indices);
    }

    public AlterTableTarget(RelationName table, @Nullable String partition, Index[] indices, @Nullable IndexTemplateMetadata indexTemplateMetadata) {
        this.table = table;
        this.partition = partition;
        this.indices = indices;
        this.indexTemplateMetadata = indexTemplateMetadata;
    }

    public AlterTableTarget(RelationName table, @Nullable String partition, Index[] indices) {
        this(table, partition, indices, null);
    }

    public boolean targetsIndividualPartition() {
        return this.partition != null;
    }

    public RelationName table() {
        return this.table;
    }

    @Nullable
    public String partition() {
        return this.partition;
    }

    public boolean isEmpty() {
        return this.indices.length == 0 && this.indexTemplateMetadata == null;
    }

    public Index[] indices() {
        return this.indices;
    }

    @Nullable
    public IndexTemplateMetadata templateMetadata() {
        return this.indexTemplateMetadata;
    }
}

