/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class AlterTableRequest
extends AcknowledgedRequest<AlterTableRequest> {
    private final RelationName tableIdent;
    @Nullable
    private final String partitionIndexName;
    private final boolean isPartitioned;
    private final boolean excludePartitions;
    private final Settings settings;
    @Nullable
    private final String mappingDelta;

    public AlterTableRequest(RelationName tableIdent, @Nullable String partitionIndexName, boolean isPartitioned, boolean excludePartitions, Settings settings, Map<String, Object> mappingDelta) throws IOException {
        this.tableIdent = tableIdent;
        this.partitionIndexName = partitionIndexName;
        this.isPartitioned = isPartitioned;
        this.excludePartitions = excludePartitions;
        this.settings = settings;
        this.mappingDelta = AlterTableRequest.mapToJson(mappingDelta);
    }

    public AlterTableRequest(StreamInput in) throws IOException {
        super(in);
        this.tableIdent = new RelationName(in);
        this.partitionIndexName = in.readOptionalString();
        this.isPartitioned = in.readBoolean();
        this.excludePartitions = in.readBoolean();
        this.settings = Settings.readSettingsFromStream(in);
        this.mappingDelta = in.readOptionalString();
    }

    public RelationName tableIdent() {
        return this.tableIdent;
    }

    @Nullable
    public String partitionIndexName() {
        return this.partitionIndexName;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public boolean excludePartitions() {
        return this.excludePartitions;
    }

    public Settings settings() {
        return this.settings;
    }

    @Nullable
    private static String mapToJson(Map<String, Object> mapping) throws IOException {
        if (mapping.isEmpty()) {
            return null;
        }
        XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
        builder.map(mapping);
        return XContentHelper.convertToJson(BytesReference.bytes(builder), XContentType.JSON);
    }

    @Nullable
    public String mappingDelta() {
        return this.mappingDelta;
    }

    public Map<String, Object> mappingDeltaAsMap() {
        if (this.mappingDelta == null) {
            return Collections.emptyMap();
        }
        return XContentHelper.convertToMap((XContent)JsonXContent.JSON_XCONTENT, this.mappingDelta, false);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.tableIdent.writeTo(out);
        out.writeOptionalString(this.partitionIndexName);
        out.writeBoolean(this.isPartitioned);
        out.writeBoolean(this.excludePartitions);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeOptionalString(this.mappingDelta);
    }
}

