/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.action.FutureActionListener;
import io.crate.action.sql.ResultReceiver;
import io.crate.action.sql.SQLOperations;
import io.crate.action.sql.Session;
import io.crate.analyze.AnalyzedAlterTableRename;
import io.crate.analyze.BoundAddColumn;
import io.crate.analyze.BoundAlterTable;
import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Row;
import io.crate.execution.ddl.index.SwapAndDropIndexRequest;
import io.crate.execution.ddl.index.TransportSwapAndDropIndexNameAction;
import io.crate.execution.ddl.tables.AlterTableRequest;
import io.crate.execution.ddl.tables.CloseTableRequest;
import io.crate.execution.ddl.tables.OpenCloseTableOrPartitionRequest;
import io.crate.execution.ddl.tables.RenameTableRequest;
import io.crate.execution.ddl.tables.TransportAlterTableAction;
import io.crate.execution.ddl.tables.TransportCloseTable;
import io.crate.execution.ddl.tables.TransportOpenCloseTableOrPartitionAction;
import io.crate.execution.ddl.tables.TransportRenameTableAction;
import io.crate.execution.support.ChainableAction;
import io.crate.execution.support.ChainableActions;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.TableInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.admin.indices.shrink.TransportResizeAction;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;

@Singleton
public class AlterTableOperation {
    public static final String RESIZE_PREFIX = ".resized.";
    private final ClusterService clusterService;
    private final TransportAlterTableAction transportAlterTableAction;
    private final TransportRenameTableAction transportRenameTableAction;
    private final TransportOpenCloseTableOrPartitionAction transportOpenCloseTableOrPartitionAction;
    private final TransportResizeAction transportResizeAction;
    private final TransportDeleteIndexAction transportDeleteIndexAction;
    private final TransportSwapAndDropIndexNameAction transportSwapAndDropIndexNameAction;
    private final TransportCloseTable transportCloseTable;
    private final SQLOperations sqlOperations;
    private Session session;

    @Inject
    public AlterTableOperation(ClusterService clusterService, TransportRenameTableAction transportRenameTableAction, TransportOpenCloseTableOrPartitionAction transportOpenCloseTableOrPartitionAction, TransportCloseTable transportCloseTable, TransportResizeAction transportResizeAction, TransportDeleteIndexAction transportDeleteIndexAction, TransportSwapAndDropIndexNameAction transportSwapAndDropIndexNameAction, TransportAlterTableAction transportAlterTableAction, SQLOperations sqlOperations) {
        this.clusterService = clusterService;
        this.transportRenameTableAction = transportRenameTableAction;
        this.transportResizeAction = transportResizeAction;
        this.transportDeleteIndexAction = transportDeleteIndexAction;
        this.transportSwapAndDropIndexNameAction = transportSwapAndDropIndexNameAction;
        this.transportOpenCloseTableOrPartitionAction = transportOpenCloseTableOrPartitionAction;
        this.transportCloseTable = transportCloseTable;
        this.transportAlterTableAction = transportAlterTableAction;
        this.sqlOperations = sqlOperations;
    }

    public CompletableFuture<Long> executeAlterTableAddColumn(BoundAddColumn analysis) {
        FutureActionListener<AcknowledgedResponse, Long> result = new FutureActionListener<AcknowledgedResponse, Long>(r -> -1L);
        if (analysis.newPrimaryKeys() || analysis.hasNewGeneratedColumns()) {
            RelationName ident = analysis.table().ident();
            String stmt = String.format(Locale.ENGLISH, "SELECT COUNT(*) FROM \"%s\".\"%s\"", ident.schema(), ident.name());
            try {
                this.session().quickExec(stmt, new ResultSetReceiver(analysis, result), Row.EMPTY);
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        } else {
            return this.addColumnToTable(analysis, result);
        }
        return result;
    }

    private Session session() {
        if (this.session == null) {
            this.session = this.sqlOperations.newSystemSession();
        }
        return this.session;
    }

    public CompletableFuture<Long> executeAlterTableOpenClose(DocTableInfo tableInfo, boolean openTable, @Nullable PartitionName partitionName) {
        String partitionIndexName = null;
        if (partitionName != null) {
            partitionIndexName = partitionName.asIndexName();
        }
        FutureActionListener<AcknowledgedResponse, Long> listener = new FutureActionListener<AcknowledgedResponse, Long>(r -> -1L);
        if (openTable || this.clusterService.state().getNodes().getMinNodeVersion().before(Version.V_4_3_0)) {
            OpenCloseTableOrPartitionRequest request = new OpenCloseTableOrPartitionRequest(tableInfo.ident(), partitionIndexName, openTable);
            this.transportOpenCloseTableOrPartitionAction.execute(request, listener);
        } else {
            this.transportCloseTable.execute(new CloseTableRequest(tableInfo.ident(), partitionIndexName), listener);
        }
        return listener;
    }

    public CompletableFuture<Long> executeAlterTable(BoundAlterTable analysis) {
        boolean isResizeOperationRequired;
        Settings settings = analysis.tableParameter().settings();
        boolean includesNumberOfShardsSetting = settings.hasValue("index.number_of_shards");
        boolean bl = isResizeOperationRequired = includesNumberOfShardsSetting && (!analysis.isPartitioned() || analysis.partitionName().isPresent());
        if (isResizeOperationRequired) {
            if (settings.size() > 1) {
                throw new IllegalArgumentException("Setting [number_of_shards] cannot be combined with other settings");
            }
            return this.executeAlterTableChangeNumberOfShards(analysis);
        }
        return this.executeAlterTableSetOrReset(analysis);
    }

    private CompletableFuture<Long> executeAlterTableSetOrReset(BoundAlterTable analysis) {
        try {
            AlterTableRequest request = new AlterTableRequest(analysis.table().ident(), analysis.partitionName().map(PartitionName::asIndexName).orElse(null), analysis.isPartitioned(), analysis.excludePartitions(), analysis.tableParameter().settings(), analysis.tableParameter().mappings());
            FutureActionListener<AcknowledgedResponse, Long> listener = new FutureActionListener<AcknowledgedResponse, Long>(r -> -1L);
            this.transportAlterTableAction.execute(request, listener);
            return listener;
        }
        catch (IOException e) {
            return FutureActionListener.failedFuture(e);
        }
    }

    private CompletableFuture<Long> executeAlterTableChangeNumberOfShards(BoundAlterTable analysis) {
        String sourceIndexAlias;
        String sourceIndexName;
        TableInfo table = analysis.table();
        boolean isPartitioned = analysis.isPartitioned();
        if (isPartitioned) {
            Optional<PartitionName> partitionName = analysis.partitionName();
            assert (partitionName.isPresent()) : "Resizing operations for partitioned tables are only supported at partition level";
            sourceIndexName = partitionName.get().asIndexName();
            sourceIndexAlias = table.ident().indexNameOrAlias();
        } else {
            sourceIndexName = table.ident().indexNameOrAlias();
            sourceIndexAlias = null;
        }
        ClusterState currentState = this.clusterService.state();
        IndexMetadata sourceIndexMetadata = currentState.metadata().index(sourceIndexName);
        int targetNumberOfShards = AlterTableOperation.getNumberOfShards(analysis.tableParameter().settings());
        AlterTableOperation.validateForResizeRequest(sourceIndexMetadata, targetNumberOfShards);
        ArrayList<ChainableAction<Long>> actions = new ArrayList<ChainableAction<Long>>();
        String resizedIndex = RESIZE_PREFIX + sourceIndexName;
        this.deleteLeftOverFromPreviousOperations(currentState, actions, resizedIndex);
        actions.add(new ChainableAction(() -> this.resizeIndex(currentState.metadata().index(sourceIndexName), sourceIndexAlias, resizedIndex, targetNumberOfShards), () -> CompletableFuture.completedFuture(-1L)));
        actions.add(new ChainableAction(() -> this.swapAndDropIndex(resizedIndex, sourceIndexName).exceptionally(error -> {
            throw new IllegalStateException("The resize operation to change the number of shards completed partially but run into a failure. Please retry the operation or clean up the internal indices with ALTER CLUSTER GC DANGLING ARTIFACTS. " + error.getMessage(), (Throwable)error);
        }), () -> CompletableFuture.completedFuture(-1L)));
        return ChainableActions.run(actions);
    }

    private void deleteLeftOverFromPreviousOperations(ClusterState currentState, List<ChainableAction<Long>> actions, String resizeIndex) {
        if (currentState.metadata().hasIndex(resizeIndex)) {
            actions.add(new ChainableAction(() -> this.deleteIndex(resizeIndex), () -> CompletableFuture.completedFuture(-1L)));
        }
    }

    private static void validateForResizeRequest(IndexMetadata sourceIndex, int targetNumberOfShards) {
        AlterTableOperation.validateNumberOfShardsForResize(sourceIndex, targetNumberOfShards);
        AlterTableOperation.validateReadOnlyIndexForResize(sourceIndex);
    }

    @VisibleForTesting
    static int getNumberOfShards(Settings settings) {
        return Objects.requireNonNull(settings.getAsInt("index.number_of_shards", null), "Setting 'number_of_shards' is missing");
    }

    @VisibleForTesting
    static void validateNumberOfShardsForResize(IndexMetadata indexMetadata, int targetNumberOfShards) {
        int currentNumberOfShards = indexMetadata.getNumberOfShards();
        if (currentNumberOfShards == targetNumberOfShards) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Table/partition is already allocated <%d> shards", currentNumberOfShards));
        }
        if (targetNumberOfShards < currentNumberOfShards && currentNumberOfShards % targetNumberOfShards != 0) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Requested number of shards: <%d> needs to be a factor of the current one: <%d>", targetNumberOfShards, currentNumberOfShards));
        }
    }

    @VisibleForTesting
    static void validateReadOnlyIndexForResize(IndexMetadata indexMetadata) {
        Boolean readOnly = indexMetadata.getSettings().getAsBoolean(IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.getKey(), Boolean.FALSE);
        if (!readOnly.booleanValue()) {
            throw new IllegalStateException("Table/Partition needs to be at a read-only state. Use 'ALTER table ... set (\"blocks.write\"=true)' and retry");
        }
    }

    private CompletableFuture<Long> resizeIndex(IndexMetadata sourceIndex, @Nullable String sourceIndexAlias, String targetIndexName, int targetNumberOfShards) {
        Settings targetIndexSettings = Settings.builder().put("index.number_of_shards", targetNumberOfShards).build();
        int currentNumShards = sourceIndex.getNumberOfShards();
        ResizeRequest request = new ResizeRequest(targetIndexName, sourceIndex.getIndex().getName());
        request.getTargetIndexRequest().settings(targetIndexSettings);
        if (sourceIndexAlias != null) {
            request.getTargetIndexRequest().alias(new Alias(sourceIndexAlias));
        }
        request.setResizeType(targetNumberOfShards > currentNumShards ? ResizeType.SPLIT : ResizeType.SHRINK);
        request.setCopySettings(Boolean.TRUE);
        request.setWaitForActiveShards(ActiveShardCount.ONE);
        FutureActionListener<ResizeResponse, Long> listener = new FutureActionListener<ResizeResponse, Long>(resp -> resp.isAcknowledged() ? 1L : 0L);
        this.transportResizeAction.execute(request, listener);
        return listener;
    }

    private CompletableFuture<Long> deleteIndex(String ... indexNames) {
        DeleteIndexRequest request = new DeleteIndexRequest(indexNames);
        FutureActionListener<AcknowledgedResponse, Long> listener = new FutureActionListener<AcknowledgedResponse, Long>(r -> 0L);
        this.transportDeleteIndexAction.execute(request, listener);
        return listener;
    }

    private CompletableFuture<Long> swapAndDropIndex(String source, String target) {
        SwapAndDropIndexRequest request = new SwapAndDropIndexRequest(source, target);
        FutureActionListener<AcknowledgedResponse, Long> listener = new FutureActionListener<AcknowledgedResponse, Long>(response -> {
            if (!response.isAcknowledged()) {
                throw new RuntimeException("Publishing new cluster state during Shrink operation (rename phase) has timed out");
            }
            return 0L;
        });
        this.transportSwapAndDropIndexNameAction.execute(request, listener);
        return listener;
    }

    public CompletableFuture<Long> executeAlterTableRenameTable(AnalyzedAlterTableRename statement) {
        DocTableInfo sourceTableInfo = statement.sourceTableInfo();
        RelationName sourceRelationName = sourceTableInfo.ident();
        RelationName targetRelationName = statement.targetTableIdent();
        return this.renameTable(sourceRelationName, targetRelationName, sourceTableInfo.isPartitioned());
    }

    private CompletableFuture<Long> renameTable(RelationName sourceRelationName, RelationName targetRelationName, boolean isPartitioned) {
        RenameTableRequest request = new RenameTableRequest(sourceRelationName, targetRelationName, isPartitioned);
        FutureActionListener<AcknowledgedResponse, Long> listener = new FutureActionListener<AcknowledgedResponse, Long>(r -> -1L);
        this.transportRenameTableAction.execute(request, listener);
        return listener;
    }

    private CompletableFuture<Long> addColumnToTable(BoundAddColumn analysis, FutureActionListener<AcknowledgedResponse, Long> result) {
        try {
            AlterTableRequest request = new AlterTableRequest(analysis.table().ident(), null, analysis.table().isPartitioned(), false, analysis.settings(), analysis.mapping());
            this.transportAlterTableAction.execute(request, result);
            return result;
        }
        catch (IOException e) {
            return FutureActionListener.failedFuture(e);
        }
    }

    private class ResultSetReceiver
    implements ResultReceiver {
        private final BoundAddColumn analysis;
        private final FutureActionListener<AcknowledgedResponse, Long> result;
        private long count;

        ResultSetReceiver(BoundAddColumn analysis, FutureActionListener<AcknowledgedResponse, Long> result) {
            this.analysis = analysis;
            this.result = result;
        }

        @Override
        public void setNextRow(Row row) {
            this.count = (Long)row.get(0);
        }

        @Override
        public void batchFinished() {
        }

        @Override
        public void allFinished(boolean interrupted) {
            if (this.count == 0L) {
                AlterTableOperation.this.addColumnToTable(this.analysis, this.result);
            } else {
                String columnFailure = this.analysis.newPrimaryKeys() ? "primary key" : "generated";
                this.fail(new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot add a %s column to a table that isn't empty", columnFailure)));
            }
        }

        @Override
        public void fail(@Nonnull Throwable t) {
            this.result.completeExceptionally(t);
        }

        @Override
        public CompletableFuture<?> completionFuture() {
            return this.result;
        }
    }
}

