/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.compress.CompressedXContent;

public final class Templates {
    public static IndexTemplateMetadata.Builder copyWithNewName(IndexTemplateMetadata source, RelationName newName) {
        String targetTemplateName = PartitionName.templateName(newName.schema(), newName.name());
        String targetAlias = newName.indexNameOrAlias();
        IndexTemplateMetadata.Builder templateBuilder = IndexTemplateMetadata.builder(targetTemplateName).patterns(Collections.singletonList(PartitionName.templatePrefix(newName.schema(), newName.name()))).settings(source.settings()).order(source.order()).putAlias(AliasMetadata.builder(targetAlias).build()).version(source.version());
        for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : source.mappings()) {
            try {
                templateBuilder.putMapping((String)objectObjectCursor.key, (CompressedXContent)objectObjectCursor.value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return templateBuilder;
    }
}

