/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl;

import io.crate.execution.ddl.RelationNameSwap;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class SwapRelationsRequest
extends AcknowledgedRequest<SwapRelationsRequest> {
    private final List<RelationNameSwap> swapRelations;
    private final List<RelationName> dropRelations;

    public SwapRelationsRequest(List<RelationNameSwap> swapRelations, List<RelationName> dropRelations) {
        this.swapRelations = swapRelations;
        this.dropRelations = dropRelations;
    }

    public List<RelationNameSwap> swapActions() {
        return this.swapRelations;
    }

    public List<RelationName> dropRelations() {
        return this.dropRelations;
    }

    public SwapRelationsRequest(StreamInput in) throws IOException {
        super(in);
        this.swapRelations = in.readList(RelationNameSwap::new);
        this.dropRelations = in.readList(RelationName::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.swapRelations);
        out.writeList(this.dropRelations);
    }
}

