/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl;

import io.crate.common.unit.TimeValue;
import io.crate.execution.ddl.SchemaUpdateRequest;
import io.crate.execution.ddl.TransportSchemaUpdateAction;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.Mapping;

@Singleton
public class SchemaUpdateClient {
    private final TransportSchemaUpdateAction schemaUpdateAction;
    private volatile TimeValue dynamicMappingUpdateTimeout;

    @Inject
    public SchemaUpdateClient(Settings settings, ClusterSettings clusterSettings, TransportSchemaUpdateAction schemaUpdateAction) {
        this.schemaUpdateAction = schemaUpdateAction;
        this.dynamicMappingUpdateTimeout = MappingUpdatedAction.INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MappingUpdatedAction.INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING, this::setDynamicMappingUpdateTimeout);
    }

    private void setDynamicMappingUpdateTimeout(TimeValue dynamicMappingUpdateTimeout) {
        this.dynamicMappingUpdateTimeout = dynamicMappingUpdateTimeout;
    }

    public void blockingUpdateOnMaster(Index index, Mapping mappingUpdate) {
        TimeValue timeout = this.dynamicMappingUpdateTimeout;
        AcknowledgedResponse response = (AcknowledgedResponse)this.schemaUpdateAction.execute(new SchemaUpdateRequest(index, mappingUpdate.toString())).actionGet();
        if (!response.isAcknowledged()) {
            throw new ElasticsearchTimeoutException("Failed to acknowledge mapping update within [" + timeout + "]", new Object[0]);
        }
    }
}

