/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.exceptions.RepositoryUnknownException;
import io.crate.exceptions.SQLExceptions;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.delete.TransportDeleteRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.put.TransportPutRepositoryAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.repositories.RepositoryException;

@Singleton
public class RepositoryService {
    private static final Logger LOGGER = LogManager.getLogger(RepositoryService.class);
    private final ClusterService clusterService;
    private final TransportDeleteRepositoryAction deleteRepositoryAction;
    private final TransportPutRepositoryAction putRepositoryAction;

    @Inject
    public RepositoryService(ClusterService clusterService, TransportDeleteRepositoryAction deleteRepositoryAction, TransportPutRepositoryAction putRepositoryAction) {
        this.clusterService = clusterService;
        this.deleteRepositoryAction = deleteRepositoryAction;
        this.putRepositoryAction = putRepositoryAction;
    }

    @Nullable
    public RepositoryMetadata getRepository(String repositoryName) {
        RepositoriesMetadata repositories = (RepositoriesMetadata)this.clusterService.state().metadata().custom("repositories");
        if (repositories != null) {
            return repositories.repository(repositoryName);
        }
        return null;
    }

    public void failIfRepositoryDoesNotExist(String repositoryName) {
        if (this.getRepository(repositoryName) == null) {
            throw new RepositoryUnknownException(repositoryName);
        }
    }

    public CompletableFuture<Long> execute(final DeleteRepositoryRequest request) {
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.deleteRepositoryAction.execute(request, new ActionListener<AcknowledgedResponse>(){

            @Override
            public void onResponse(AcknowledgedResponse deleteRepositoryResponse) {
                if (!deleteRepositoryResponse.isAcknowledged()) {
                    LOGGER.info("delete repository '{}' not acknowledged", (Object)request.name());
                }
                future.complete(1L);
            }

            @Override
            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Long> execute(final PutRepositoryRequest request) {
        final CompletableFuture<Long> result = new CompletableFuture<Long>();
        this.putRepositoryAction.execute(request, new ActionListener<AcknowledgedResponse>(){

            @Override
            public void onResponse(AcknowledgedResponse putRepositoryResponse) {
                result.complete(1L);
            }

            @Override
            public void onFailure(Exception e) {
                Throwable t = RepositoryService.convertRepositoryException(e);
                RepositoryService.this.dropIfExists(request.name(), () -> result.completeExceptionally(t));
            }
        });
        return result;
    }

    private void dropIfExists(String repoName, Runnable callback) {
        RepositoryMetadata repository = this.getRepository(repoName);
        if (repository == null) {
            callback.run();
        } else {
            this.execute(new DeleteRepositoryRequest(repoName)).whenComplete((result, t) -> {
                if (t != null) {
                    LOGGER.error("Error occurred whilst trying to delete repository", t);
                }
                callback.run();
            });
        }
    }

    @VisibleForTesting
    static Throwable convertRepositoryException(Throwable e) {
        e = SQLExceptions.unwrap(e);
        Throwable cause = e.getCause();
        if (e instanceof RepositoryException && cause != null) {
            Object msg = e.getMessage();
            if (cause instanceof CreationException && cause.getCause() != null) {
                msg = (String)msg + ": " + cause.getCause().getMessage();
            }
            return new RepositoryException("", (String)msg, e);
        }
        return e;
    }
}

