/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public abstract class AbstractDDLTransportAction<Request extends AcknowledgedRequest<Request>, Response extends AcknowledgedResponse>
extends TransportMasterNodeAction<Request, Response> {
    private final Writeable.Reader<Response> reader;
    private final Function<Boolean, Response> ackedResponseFunction;
    private final String source;

    public AbstractDDLTransportAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Request> requestReader, Writeable.Reader<Response> responseReader, Function<Boolean, Response> ackedResponseFunction, String source) {
        super(actionName, transportService, clusterService, threadPool, requestReader, indexNameExpressionResolver);
        this.reader = responseReader;
        this.ackedResponseFunction = ackedResponseFunction;
        this.source = source;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected Response read(StreamInput in) throws IOException {
        return (Response)((AcknowledgedResponse)this.reader.read(in));
    }

    @Override
    protected void masterOperation(Task task, Request request, ClusterState state, final ActionListener<Response> listener) throws Exception {
        this.clusterService.submitStateUpdateTask(this.source, request, ClusterStateTaskConfig.build(Priority.HIGH, ((MasterNodeRequest)request).masterNodeTimeout()), this.clusterStateTaskExecutor(request), new AckedClusterStateTaskListener(){
            final /* synthetic */ AcknowledgedRequest val$request;
            {
                this.val$request = acknowledgedRequest;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Exception e) {
                listener.onResponse((AcknowledgedResponse)AbstractDDLTransportAction.this.ackedResponseFunction.apply(true));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse((AcknowledgedResponse)AbstractDDLTransportAction.this.ackedResponseFunction.apply(false));
            }

            @Override
            public TimeValue ackTimeout() {
                return this.val$request.ackTimeout();
            }
        });
    }

    public abstract ClusterStateTaskExecutor<Request> clusterStateTaskExecutor(Request var1);
}

