/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution;

import io.crate.data.CollectingRowConsumer;
import io.crate.data.Row;
import io.crate.execution.engine.FirstColumnConsumers;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.SubQueryResults;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class MultiPhaseExecutor {
    private MultiPhaseExecutor() {
    }

    public static CompletableFuture<SubQueryResults> execute(Map<LogicalPlan, SelectSymbol> dependencies, DependencyCarrier executor, PlannerContext plannerContext, Row params) {
        ArrayList<CompletionStage> dependencyFutures = new ArrayList<CompletionStage>(dependencies.size());
        IdentityHashMap valueBySubQuery = new IdentityHashMap();
        for (Map.Entry<LogicalPlan, SelectSymbol> entry : dependencies.entrySet()) {
            LogicalPlan depPlan = entry.getKey();
            SelectSymbol selectSymbol = entry.getValue();
            CollectingRowConsumer<?, ?> rowConsumer = MultiPhaseExecutor.getConsumer(selectSymbol.getResultType());
            depPlan.execute(executor, PlannerContext.forSubPlan(plannerContext), rowConsumer, params, SubQueryResults.EMPTY);
            dependencyFutures.add(rowConsumer.completionFuture().thenAccept(val -> {
                IdentityHashMap identityHashMap = valueBySubQuery;
                synchronized (identityHashMap) {
                    valueBySubQuery.put(selectSymbol, val);
                }
            }));
        }
        return CompletableFuture.allOf(dependencyFutures.toArray(new CompletableFuture[0])).thenApply(ignored -> new SubQueryResults(valueBySubQuery));
    }

    private static CollectingRowConsumer<?, ?> getConsumer(SelectSymbol.ResultType resultType) {
        switch (resultType) {
            case SINGLE_COLUMN_SINGLE_VALUE: {
                return FirstColumnConsumers.createSingleRowConsumer();
            }
            case SINGLE_COLUMN_MULTIPLE_VALUES: {
                return FirstColumnConsumers.createAllRowsConsumer();
            }
        }
        throw new IllegalStateException("Can't create consumer: Unknown ResultType");
    }
}

