/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.TableScopeException;
import io.crate.metadata.RelationName;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.elasticsearch.index.shard.ShardId;

public class UnavailableShardsException
extends RuntimeException
implements TableScopeException {
    private final RelationName relationName;

    public UnavailableShardsException(ShardId shardId) {
        super(UnavailableShardsException.genMessage(shardId));
        this.relationName = RelationName.fromIndexName(shardId.getIndexName());
    }

    private static String genMessage(ShardId shardId) {
        return String.format(Locale.ENGLISH, "the shard %s of table %s is not available", shardId.getId(), shardId.getIndex());
    }

    public Collection<RelationName> getTableIdents() {
        return Collections.singletonList(this.relationName);
    }
}

