/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import com.google.common.util.concurrent.UncheckedExecutionException;
import io.crate.auth.user.AccessControl;
import io.crate.exceptions.CrateException;
import io.crate.exceptions.DuplicateKeyException;
import io.crate.exceptions.Exceptions;
import io.crate.exceptions.InvalidRelationName;
import io.crate.exceptions.JobKilledException;
import io.crate.exceptions.RelationAlreadyExists;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.RepositoryUnknownException;
import io.crate.exceptions.SQLParseException;
import io.crate.exceptions.SnapshotAlreadyExistsException;
import io.crate.exceptions.SnapshotNameInvalidException;
import io.crate.exceptions.SnapshotUnknownException;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.metadata.PartitionName;
import io.crate.sql.parser.ParsingException;
import java.util.Locale;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.InvalidIndexTemplateException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.SnapshotCreationException;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.transport.TransportException;

public class SQLExceptions {
    private static final Logger LOGGER = LogManager.getLogger(SQLExceptions.class);
    private static final Predicate<Throwable> EXCEPTIONS_TO_UNWRAP = throwable -> throwable instanceof TransportException || throwable instanceof UncheckedExecutionException || throwable instanceof CompletionException || throwable instanceof UncategorizedExecutionException || throwable instanceof ExecutionException;

    public static Throwable unwrap(@Nonnull Throwable t, @Nullable Predicate<Throwable> additionalUnwrapCondition) {
        int counter = 0;
        Throwable result = t;
        Predicate<Throwable> unwrapCondition = EXCEPTIONS_TO_UNWRAP;
        if (additionalUnwrapCondition != null) {
            unwrapCondition = unwrapCondition.or(additionalUnwrapCondition);
        }
        while (unwrapCondition.test(result)) {
            Throwable cause = result.getCause();
            if (cause == null) {
                return result;
            }
            if (cause == result) {
                return result;
            }
            if (counter > 10) {
                LOGGER.warn("Exception cause unwrapping ran for 10 levels. Aborting unwrap", t);
                return result;
            }
            ++counter;
            result = cause;
        }
        return result;
    }

    public static Throwable unwrap(@Nonnull Throwable t) {
        return SQLExceptions.unwrap(t, null);
    }

    public static String messageOf(@Nullable Throwable t) {
        if (t == null) {
            return "Unknown";
        }
        Throwable unwrappedT = SQLExceptions.unwrap(t);
        if (unwrappedT.getMessage() == null) {
            StackTraceElement[] stackTraceElements;
            if (unwrappedT instanceof CrateException && unwrappedT.getCause() != null) {
                unwrappedT = unwrappedT.getCause();
            }
            if ((stackTraceElements = unwrappedT.getStackTrace()).length > 0) {
                return String.format(Locale.ENGLISH, "%s in %s", unwrappedT.getClass().getSimpleName(), stackTraceElements[0]);
            }
            return "Error in " + unwrappedT.getClass().getSimpleName();
        }
        return unwrappedT.getMessage();
    }

    public static boolean isShardFailure(Throwable e) {
        return (e = SQLExceptions.unwrap(e)) instanceof ShardNotFoundException || e instanceof IllegalIndexShardStateException;
    }

    public static RuntimeException prepareForClientTransmission(AccessControl accessControl, Throwable e) {
        Throwable unwrappedError = SQLExceptions.unwrap(e);
        e = SQLExceptions.esToCrateException(unwrappedError);
        try {
            accessControl.ensureMaySee(e);
        }
        catch (Exception mpe) {
            e = mpe;
        }
        return Exceptions.toRuntimeException(e);
    }

    private static Throwable esToCrateException(Throwable unwrappedError) {
        if (unwrappedError instanceof IllegalArgumentException || unwrappedError instanceof ParsingException) {
            return new SQLParseException(unwrappedError.getMessage(), (Exception)unwrappedError);
        }
        if (unwrappedError instanceof UnsupportedOperationException) {
            return new UnsupportedFeatureException(unwrappedError.getMessage(), (Exception)unwrappedError);
        }
        if (SQLExceptions.isDocumentAlreadyExistsException(unwrappedError)) {
            return new DuplicateKeyException(((EngineException)unwrappedError).getIndex().getName(), "A document with the same primary key exists already", unwrappedError);
        }
        if (unwrappedError instanceof ResourceAlreadyExistsException) {
            return new RelationAlreadyExists(((ResourceAlreadyExistsException)unwrappedError).getIndex().getName(), unwrappedError);
        }
        if (unwrappedError instanceof InvalidIndexNameException) {
            if (unwrappedError.getMessage().contains("already exists as alias")) {
                return new RelationAlreadyExists(((InvalidIndexNameException)unwrappedError).getIndex().getName(), unwrappedError);
            }
            return new InvalidRelationName(((InvalidIndexNameException)unwrappedError).getIndex().getName(), unwrappedError);
        }
        if (unwrappedError instanceof InvalidIndexTemplateException) {
            PartitionName partitionName = PartitionName.fromIndexOrTemplate(((InvalidIndexTemplateException)unwrappedError).name());
            return new InvalidRelationName(partitionName.relationName().fqn(), unwrappedError);
        }
        if (unwrappedError instanceof IndexNotFoundException) {
            return new RelationUnknown(((IndexNotFoundException)unwrappedError).getIndex().getName(), unwrappedError);
        }
        if (unwrappedError instanceof InterruptedException) {
            return JobKilledException.of(unwrappedError.getMessage());
        }
        if (unwrappedError instanceof RepositoryMissingException) {
            return new RepositoryUnknownException(((RepositoryMissingException)unwrappedError).repository());
        }
        if (unwrappedError instanceof InvalidSnapshotNameException) {
            return new SnapshotNameInvalidException(unwrappedError.getMessage());
        }
        if (unwrappedError instanceof SnapshotMissingException) {
            SnapshotMissingException snapshotException = (SnapshotMissingException)unwrappedError;
            return new SnapshotUnknownException(snapshotException.getRepositoryName(), snapshotException.getSnapshotName(), unwrappedError);
        }
        if (unwrappedError instanceof SnapshotCreationException) {
            SnapshotCreationException creationException = (SnapshotCreationException)unwrappedError;
            return new SnapshotAlreadyExistsException(creationException.getRepositoryName(), creationException.getSnapshotName());
        }
        return unwrappedError;
    }

    public static boolean isDocumentAlreadyExistsException(Throwable e) {
        return e instanceof VersionConflictEngineException && e.getMessage().contains("document already exists");
    }

    public static String userFriendlyCrateExceptionTopOnly(Throwable e) {
        return SQLExceptions.esToCrateException(e).getMessage();
    }
}

