/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.common.collections.Lists2;
import io.crate.exceptions.ResourceUnknownException;
import io.crate.exceptions.TableScopeException;
import io.crate.metadata.RelationName;
import io.crate.sql.Identifiers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class RelationUnknown
extends ResourceUnknownException
implements TableScopeException {
    private final RelationName relationName;

    public static RelationUnknown of(String relation, List<String> candidates) {
        switch (candidates.size()) {
            case 0: {
                return new RelationUnknown(relation);
            }
            case 1: {
                RelationName name = RelationName.fromIndexName(relation);
                String msg = "Relation '" + relation + "' unknown. Maybe you meant '" + Identifiers.quoteIfNeeded(candidates.get(0)) + "'";
                return new RelationUnknown(name, msg);
            }
        }
        RelationName name = RelationName.fromIndexName(relation);
        String msg = "Relation '" + relation + "' unknown. Maybe you meant one of: " + String.join((CharSequence)", ", Lists2.map(candidates, Identifiers::quoteIfNeeded));
        return new RelationUnknown(name, msg);
    }

    public RelationUnknown(String tableName, Throwable e) {
        super(String.format(Locale.ENGLISH, "Relation '%s' unknown", tableName), e);
        this.relationName = RelationName.fromIndexName(tableName);
    }

    public RelationUnknown(String tableName) {
        this(RelationName.fromIndexName(tableName), String.format(Locale.ENGLISH, "Relation '%s' unknown", tableName));
    }

    public RelationUnknown(RelationName relationName) {
        this(relationName, String.format(Locale.ENGLISH, "Relation '%s' unknown", relationName));
    }

    private RelationUnknown(RelationName relationName, String errorMessage) {
        super(errorMessage);
        this.relationName = relationName;
    }

    public Collection<RelationName> getTableIdents() {
        return Collections.singletonList(this.relationName);
    }
}

