/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.ResourceUnknownException;
import io.crate.exceptions.TableScopeException;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.Collections;
import java.util.Locale;

public class PartitionUnknownException
extends ResourceUnknownException
implements TableScopeException {
    private RelationName relationName;

    public PartitionUnknownException(PartitionName partitionName) {
        super(String.format(Locale.ENGLISH, "No partition for table '%s' with ident '%s' exists", partitionName.relationName().fqn(), partitionName.ident()));
        this.relationName = partitionName.relationName();
    }

    @Override
    public Iterable<RelationName> getTableIdents() {
        return Collections.singletonList(this.relationName);
    }
}

